"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverridenCount = exports.default = exports.LabsFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("../../i18n");
var _presentation_labs_service = require("../../services/presentation_labs_service");
var _project_list = require("./project_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const {
  Flyout: strings
} = _i18n.LabsStrings.Components;
const hasStatusChanged = (original, current) => {
  for (const id of Object.keys(original)) {
    for (const key of Object.keys(original[id].status)) {
      if (original[id].status[key] !== current[id].status[key]) {
        return true;
      }
    }
  }
  return false;
};
const getOverridenCount = projects => Object.values(projects).filter(project => project.status.isOverride).length;
exports.getOverridenCount = getOverridenCount;
const LabsFlyout = props => {
  const {
    solutions,
    onEnabledCountChange = () => {},
    onClose
  } = props;
  const labsService = (0, _react.useMemo)(() => (0, _presentation_labs_service.getPresentationLabsService)(), []);
  const [projects, setProjects] = (0, _react.useState)(labsService.getProjects());
  const [overrideCount, setOverrideCount] = (0, _react.useState)(getOverridenCount(projects));
  const initialStatus = (0, _react.useRef)(labsService.getProjects());
  const isChanged = hasStatusChanged(initialStatus.current, projects);
  (0, _react.useEffect)(() => {
    setOverrideCount(getOverridenCount(projects));
  }, [projects]);
  (0, _react.useEffect)(() => {
    onEnabledCountChange(overrideCount);
  }, [onEnabledCountChange, overrideCount]);
  const onStatusChange = (id, env, enabled) => {
    labsService.setProjectStatus(id, env, enabled);
    setProjects(labsService.getProjects());
  };
  let footer = null;
  const resetButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      labsService.reset();
      setProjects(labsService.getProjects());
    },
    isDisabled: !overrideCount
  }, strings.getResetToDefaultLabel());
  const refreshButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: () => {
      window.location.reload();
    },
    isDisabled: !isChanged
  }, strings.getRefreshLabel());
  footer = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => onClose(),
    flush: "left"
  }, strings.getCloseButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, resetButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, refreshButton)))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    hideCloseButton: true,
    maskProps: {
      headerZindexLocation: 'below'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "beaker",
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, strings.getTitleLabel())))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, strings.getDescriptionMessage()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_project_list.ProjectList, {
    projects,
    solutions,
    onStatusChange
  })), footer);
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.LabsFlyout = LabsFlyout;
var _default = exports.default = LabsFlyout;