"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNeutralPalette = void 0;
var _i18n = require("@kbn/i18n");
var _categorical_palette = require("../../classes/categorical_palette");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const schemeGreys = ['#f2f4fb', '#d4d9e5', '#98a2b3', '#696f7d', '#353642'];
const NEUTRAL_COLOR_LIGHT = schemeGreys.slice();
const NEUTRAL_COLOR_DARK = schemeGreys.slice().reverse();
const getNeutralPalette = darkMode => new _categorical_palette.KbnCategoricalPalette({
  id: _constants.KbnPalette.Neutral,
  name: _i18n.i18n.translate('palettes.elastic.name', {
    defaultMessage: 'Neutral'
  }),
  standalone: true,
  colors: darkMode ? NEUTRAL_COLOR_DARK : NEUTRAL_COLOR_LIGHT
});
exports.getNeutralPalette = getNeutralPalette;