"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnPalettes = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class KbnPalettes {
  constructor(palettes, defaultPalette) {
    (0, _defineProperty2.default)(this, "_palettes", void 0);
    (0, _defineProperty2.default)(this, "_aliasMappings", void 0);
    (0, _defineProperty2.default)(this, "_defaultPalette", void 0);
    (0, _defineProperty2.default)(this, "query", id => {
      var _ref;
      const aliasedId = (_ref = this._palettes.has(id) ? id : this._aliasMappings.get(id)) !== null && _ref !== void 0 ? _ref : id;
      return this._palettes.get(aliasedId);
    });
    (0, _defineProperty2.default)(this, "get", id => {
      var _this$query;
      return (_this$query = this.query(id)) !== null && _this$query !== void 0 ? _this$query : this._defaultPalette;
    });
    (0, _defineProperty2.default)(this, "getAll", () => {
      return Array.from(this._palettes.values()).filter(({
        standalone
      }) => !standalone);
    });
    this._defaultPalette = defaultPalette;
    this._palettes = new Map(palettes.map(p => [p.id, p]));
    this._aliasMappings = buildAliasMappings(palettes);
  }
}
exports.KbnPalettes = KbnPalettes;
function buildAliasMappings(palettes) {
  return palettes.reduce((acc, {
    id,
    aliases
  }) => {
    aliases.forEach(alias => {
      if (!acc.has(alias)) acc.set(alias, id);
    });
    return acc;
  }, new Map());
}