"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readPackRoute = void 0;
var _lodash = require("lodash");
var _common = require("@kbn/fleet-plugin/common");
var _route_validation = require("../../utils/build_validation/route_validation");
var _constants = require("../../../common/constants");
var _common2 = require("../../../common");
var _types = require("../../../common/types");
var _utils = require("./utils");
var _utils2 = require("../utils");
var _api = require("../../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readPackRoute = router => {
  router.versioned.get({
    access: 'public',
    path: '/api/osquery/packs/{id}',
    security: {
      authz: {
        requiredPrivileges: [`${_common2.PLUGIN_ID}-readPacks`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: (0, _route_validation.buildRouteValidation)(_api.readPacksRequestParamsSchema)
      }
    }
  }, async (context, request, response) => {
    const coreContext = await context.core;
    const savedObjectsClient = coreContext.savedObjects.client;
    const {
      attributes,
      references,
      id,
      ...rest
    } = await savedObjectsClient.get(_types.packSavedObjectType, request.params.id);
    const policyIds = (0, _lodash.map)((0, _lodash.filter)(references, ['type', _common.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE]), 'id');
    const osqueryPackAssetReference = !!(0, _lodash.filter)(references, ['type', 'osquery-pack-asset']);
    const data = {
      type: rest.type,
      namespaces: rest.namespaces,
      migrationVersion: rest.migrationVersion,
      managed: rest.managed,
      coreMigrationVersion: rest.coreMigrationVersion,
      name: attributes.name,
      description: attributes.description,
      version: attributes.version,
      enabled: attributes.enabled,
      created_at: attributes.created_at,
      created_by: attributes.created_by,
      updated_at: attributes.updated_at,
      updated_by: attributes.updated_by,
      saved_object_id: id,
      queries: (0, _utils.convertSOQueriesToPack)(attributes.queries),
      shards: (0, _utils2.convertShardsToObject)(attributes.shards),
      policy_ids: policyIds,
      read_only: attributes.version !== undefined && osqueryPackAssetReference
    };
    return response.ok({
      body: {
        data
      }
    });
  });
};
exports.readPackRoute = readPackRoute;