"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../common/constants");
var _common = require("../../common");
var _kibana = require("../common/lib/kibana");
var _page_paths = require("../common/page_paths");
var _use_error_toast = require("../common/hooks/use_error_toast");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSavedQuery = ({
  savedQueryId
}) => {
  const {
    application: {
      navigateToApp
    },
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)([_constants2.SAVED_QUERY_ID, {
    savedQueryId
  }], () => http.get(`/api/osquery/saved_queries/${savedQueryId}`, {
    version: _constants.API_VERSIONS.public.v1
  }), {
    keepPreviousData: true,
    refetchOnWindowFocus: false,
    select: response => response.data,
    onSuccess: data => {
      if (data.error) {
        setErrorToast(data.error, {
          title: data.error.error,
          toastMessage: data.error.message
        });
        navigateToApp(_common.PLUGIN_ID, {
          path: _page_paths.pagePathGetters.saved_queries()
        });
      }
    },
    onError: error => {
      setErrorToast(error, {
        title: error.body.error,
        toastMessage: error.body.message
      });
    }
  });
};
exports.useSavedQuery = useSavedQuery;