"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackTypeSelectable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _styled = _interopRequireDefault(require("@emotion/styled"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiCard = (0, _styled.default)(_eui.EuiCard)`
  padding: 16px 92px 16px 16px !important;
  border: ${({
  theme,
  selectable
}) => {
  if (selectable !== null && selectable !== void 0 && selectable.isSelected) {
    return `${theme.euiTheme.border.width.thin} solid ${theme.euiTheme.colors.success}`;
  }
}};

  .euiTitle {
    font-size: 1rem;
  }

  .euiSpacer {
    display: none;
  }

  .euiText {
    margin-top: 0;
    margin-left: 25px;
    color: ${({
  theme
}) => theme.euiTheme.colors.subduedText};
  }

  > button[role='switch'] {
    display: none;
  }
`;
const PackTypeSelectableComponent = ({
  packType,
  setPackType,
  resetFormFields
}) => {
  const handleChange = (0, _react.useCallback)(type => {
    setPackType(type);
    if (resetFormFields) {
      resetFormFields();
    }
  }, [resetFormFields, setPackType]);
  const policyCardSelectable = (0, _react.useMemo)(() => ({
    onClick: () => handleChange('policy'),
    isSelected: packType === 'policy'
  }), [packType, handleChange]);
  const globalCardSelectable = (0, _react.useMemo)(() => ({
    onClick: () => handleChange('global'),
    isSelected: packType === 'global'
  }), [packType, handleChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Type",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledEuiCard, (0, _extends2.default)({
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
      id: 'osquery_pack_type_policy',
      label: _i18n.i18n.translate('xpack.osquery.pack.form.policyLabel', {
        defaultMessage: 'Policy'
      }),
      onChange: _lodash.noop,
      checked: packType === 'policy'
    }),
    titleSize: "xs",
    hasBorder: true,
    description: _i18n.i18n.translate('xpack.osquery.pack.form.policyDescription', {
      defaultMessage: 'Schedule pack for specific policy.'
    }),
    "data-test-subj": 'osqueryPackTypePolicy',
    selectable: policyCardSelectable
  }, packType === 'policy' && {
    color: 'primary'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledEuiCard, (0, _extends2.default)({
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
      id: 'osquery_pack_type_global',
      label: _i18n.i18n.translate('xpack.osquery.pack.form.globalLabel', {
        defaultMessage: 'Global'
      }),
      onChange: _lodash.noop,
      checked: packType === 'global'
    }),
    titleSize: "xs",
    description: _i18n.i18n.translate('xpack.osquery.pack.form.globalDescription', {
      defaultMessage: 'Use pack across all policies'
    }),
    selectable: globalCardSelectable,
    "data-test-subj": 'osqueryPackTypeGlobal'
  }, packType === 'global' && {
    color: 'primary'
  }))))));
};
const PackTypeSelectable = exports.PackTypeSelectable = /*#__PURE__*/_react.default.memo(PackTypeSelectableComponent);