"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToCaseWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _pack_queries_attachment_wrapper = require("../shared_components/attachments/pack_queries_attachment_wrapper");
var _kibana = require("../common/lib/kibana");
var _add_to_cases_button = require("./add_to_cases_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASES_OWNER = [];
const AddToCaseWrapper = exports.AddToCaseWrapper = /*#__PURE__*/_react.default.memo(props => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const isCasesAttachment = (0, _react.useContext)(_pack_queries_attachment_wrapper.CasesAttachmentWrapperContext);
  if (isCasesAttachment || !props.actionId) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const casePermissions = cases.helpers.canUseCases();
  const CasesContext = cases.ui.getCasesContext();
  return /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: CASES_OWNER,
    permissions: casePermissions
  }, /*#__PURE__*/_react.default.createElement(_add_to_cases_button.AddToCaseButton, props));
});
AddToCaseWrapper.displayName = 'AddToCaseWrapper';