"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeSampleDocumentsWithFieldCaps = mergeSampleDocumentsWithFieldCaps;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeSampleDocumentsWithFieldCaps({
  total,
  samples,
  fieldCaps
}) {
  const nonEmptyFields = new Set();
  const fieldValues = new Map();
  for (const document of samples) {
    Object.keys(document).forEach(field => {
      var _fieldValues$get;
      if (!nonEmptyFields.has(field)) {
        nonEmptyFields.add(field);
      }
      const values = (0, _lodash.castArray)(document[field]);
      const currentFieldValues = (_fieldValues$get = fieldValues.get(field)) !== null && _fieldValues$get !== void 0 ? _fieldValues$get : [];
      values.forEach(value => {
        if (typeof value === 'string' || typeof value === 'number' || typeof value === 'boolean') {
          currentFieldValues.push(value);
        }
      });
      fieldValues.set(field, currentFieldValues);
    });
  }
  const fields = fieldCaps.flatMap(spec => {
    var _spec$esTypes;
    const values = fieldValues.get(spec.name);
    const countByValues = new Map();
    values === null || values === void 0 ? void 0 : values.forEach(value => {
      var _countByValues$get;
      const currentCount = (_countByValues$get = countByValues.get(value)) !== null && _countByValues$get !== void 0 ? _countByValues$get : 0;
      countByValues.set(value, currentCount + 1);
    });
    const sortedValues = (0, _lodash.sortBy)(Array.from(countByValues.entries()).map(([value, count]) => {
      return {
        value,
        count
      };
    }), 'count', 'desc');
    return {
      name: spec.name,
      types: (_spec$esTypes = spec.esTypes) !== null && _spec$esTypes !== void 0 ? _spec$esTypes : [],
      empty: !nonEmptyFields.has(spec.name),
      cardinality: countByValues.size || null,
      values: (0, _lodash.uniq)(sortedValues.flatMap(({
        value
      }) => value))
    };
  });
  return {
    total,
    sampled: samples.length,
    fields
  };
}