"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.termQuery = termQuery;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function termQuery(field, value, opts = {
  queryEmptyString: true
}) {
  if (value === null || value === undefined || !opts.queryEmptyString && value === '') {
    return [];
  }
  return [{
    term: {
      [field]: value
    }
  }];
}