"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityTour = ObservabilityTour;
exports.useObservabilityTourContext = exports.observTourStepStorageKey = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _common = require("../../../common");
var _steps_config = require("./steps_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const minWidth = 360;
const maxWidth = 360;
const offset = 30;
const repositionOnScroll = true;
const overviewPath = '/overview';
const dataAssistantStep = 6;
const observTourStepStorageKey = exports.observTourStepStorageKey = 'guidedOnboarding.observability.tourStep';
const getSteps = ({
  activeStep,
  incrementStep,
  endTour,
  prependBasePath
}) => {
  const footerAction = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => endTour(),
    size: "xs",
    color: "text"
    // Used for testing and to track FS usage
    ,
    "data-test-subj": "onboarding--observTourSkipButton"
  }, _i18n.i18n.translate('xpack.observabilityShared.tour.skipButtonLabel', {
    defaultMessage: 'Skip tour'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => incrementStep(),
    size: "s",
    color: "success"
    // Used for testing and to track FS usage
    ,
    "data-test-subj": "onboarding--observTourNextStepButton"
  }, _i18n.i18n.translate('xpack.observabilityShared.tour.nextButtonLabel', {
    defaultMessage: 'Next'
  }))));
  const lastStepFooterAction =
  /*#__PURE__*/
  // data-test-subj is used for testing and to track FS usage
  _react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    onClick: () => endTour(),
    "data-test-subj": "onboarding--observTourEndButton"
  }, _i18n.i18n.translate('xpack.observabilityShared.tour.endButtonLabel', {
    defaultMessage: 'End tour'
  }));
  return _steps_config.tourStepsConfig.map((stepConfig, index) => {
    const step = index + 1;
    const {
      dataTestSubj,
      content,
      offset: stepOffset,
      imageConfig,
      ...tourStepProps
    } = stepConfig;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, (0, _extends2.default)({}, tourStepProps, {
      key: step,
      step: step,
      minWidth: minWidth,
      maxWidth: maxWidth,
      offset: stepOffset !== null && stepOffset !== void 0 ? stepOffset : offset,
      repositionOnScroll: repositionOnScroll,
      stepsTotal: _steps_config.tourStepsConfig.length,
      isStepOpen: step === activeStep,
      onFinish: () => endTour(),
      footerAction: activeStep === _steps_config.tourStepsConfig.length ? lastStepFooterAction : footerAction,
      panelProps: {
        'data-test-subj': dataTestSubj
      },
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("p", null, content)), imageConfig && prependBasePath && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
        alt: imageConfig.altText,
        src: prependBasePath(`/plugins/observability/assets/${imageConfig.name}`),
        size: "fullWidth"
      })))
    }));
  });
};
const ObservabilityTourContext = /*#__PURE__*/(0, _react.createContext)({
  endTour: () => {},
  isTourVisible: false
});
function ObservabilityTour({
  children,
  navigateToApp,
  isPageDataLoaded,
  showTour,
  prependBasePath,
  guidedOnboardingApi
}) {
  const prevActiveStep = localStorage.getItem(observTourStepStorageKey);
  const initialActiveStep = prevActiveStep === null ? 1 : Number(prevActiveStep);
  const isGuidedOnboardingActive = (0, _useObservable.default)(
  // if guided onboarding is not available, return false
  guidedOnboardingApi ? guidedOnboardingApi.isGuideStepActive$('kubernetes', 'tour_observability') : (0, _rxjs.of)(false));
  const [isTourActive, setIsTourActive] = (0, _react.useState)(false);
  const [activeStep, setActiveStep] = (0, _react.useState)(initialActiveStep);
  const {
    pathname: currentPath
  } = (0, _reactRouterDom.useLocation)();
  const isSmallBreakpoint = (0, _eui.useIsWithinBreakpoints)(['s']);
  const isOverviewPage = currentPath === overviewPath;
  const incrementStep = (0, _react.useCallback)(() => {
    setActiveStep(prevState => prevState + 1);
  }, []);
  const endTour = (0, _react.useCallback)(async () => {
    // Mark the onboarding guide step as complete
    if (guidedOnboardingApi) {
      await guidedOnboardingApi.completeGuideStep('kubernetes', 'tour_observability');
    }
    // Reset EuiTour step state
    setActiveStep(1);
  }, [guidedOnboardingApi]);

  /**
   * The tour should only be visible if the following conditions are met:
   * - Only pages with the side nav should show the tour (showTour === true)
   * - Tour is set to active per the guided onboarding service (isTourActive === true)
   * - Any page data must be loaded in order for the tour to render correctly
   * - The tour should only render on medium-large screens
   */
  const isTourVisible = showTour && isTourActive && isPageDataLoaded && isSmallBreakpoint === false;
  const context = {
    endTour,
    isTourVisible
  };
  (0, _react.useEffect)(() => {
    localStorage.setItem(observTourStepStorageKey, String(activeStep));
  }, [activeStep]);
  (0, _react.useEffect)(() => {
    setIsTourActive(Boolean(isGuidedOnboardingActive));
  }, [isGuidedOnboardingActive]);
  (0, _react.useEffect)(() => {
    // The user must be on the overview page to view the data assistant step in the tour
    if (isTourActive && isOverviewPage === false && activeStep === dataAssistantStep) {
      navigateToApp(_common.observabilityAppId, {
        path: overviewPath
      });
    }
  }, [activeStep, isOverviewPage, isTourActive, navigateToApp]);
  return /*#__PURE__*/_react.default.createElement(ObservabilityTourContext.Provider, {
    value: context
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children({
    isTourVisible
  }), isTourVisible && getSteps({
    activeStep,
    incrementStep,
    endTour,
    prependBasePath
  })));
}
const useObservabilityTourContext = () => {
  const ctx = (0, _react.useContext)(ObservabilityTourContext);
  if (!ctx) {
    throw new Error('useObservabilityTourContext can only be called inside of TourContext');
  }
  return ctx;
};
exports.useObservabilityTourContext = useObservabilityTourContext;