"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SupportedAssetTypes = exports.AssetDetailsLocatorDefinition = exports.ASSET_DETAILS_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rison = _interopRequireDefault(require("@kbn/rison"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SupportedAssetTypes = exports.SupportedAssetTypes = /*#__PURE__*/function (SupportedAssetTypes) {
  SupportedAssetTypes["container"] = "container";
  SupportedAssetTypes["host"] = "host";
  return SupportedAssetTypes;
}({});
const ASSET_DETAILS_LOCATOR_ID = exports.ASSET_DETAILS_LOCATOR_ID = 'ASSET_DETAILS_LOCATOR';
class AssetDetailsLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", ASSET_DETAILS_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      // Check which asset types are currently supported
      const isSupportedByAssetDetails = Object.values(SupportedAssetTypes).includes(params.assetType);

      // Map the compatible parameters to _a compatible shape
      const mappedAssetParams = params.assetDetails && !isSupportedByAssetDetails ? {
        time: params.assetDetails.dateRange
      } : undefined;
      const legacyNodeDetailsQueryParams = !isSupportedByAssetDetails ? _rison.default.encodeUnknown({
        ...mappedAssetParams,
        ...params._a
      }) : undefined;
      const assetDetailsQueryParams = isSupportedByAssetDetails ? _rison.default.encodeUnknown(params.assetDetails) : undefined;
      const queryParams = [];
      if (assetDetailsQueryParams !== undefined) {
        queryParams.push(`assetDetails=${assetDetailsQueryParams}`);
      }
      if (legacyNodeDetailsQueryParams !== undefined) {
        queryParams.push(`_a=${legacyNodeDetailsQueryParams}`);
      }
      return {
        app: 'metrics',
        path: `/detail/${params.assetType}/${params.assetId}?${queryParams.join('&')}`,
        state: params.state ? params.state : {}
      };
    });
  }
}
exports.AssetDetailsLocatorDefinition = AssetDetailsLocatorDefinition;