"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestedDashboardSchema = exports.relatedDashboardSchema = void 0;
var _zod = require("@kbn/zod");
var _latest = require("../relevant_panel/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const relatedDashboardSchema = exports.relatedDashboardSchema = _zod.z.object({
  id: _zod.z.string(),
  title: _zod.z.string(),
  description: _zod.z.string(),
  matchedBy: _zod.z.object({
    fields: _zod.z.array(_zod.z.string()).optional(),
    index: _zod.z.array(_zod.z.string()).optional(),
    linked: _zod.z.boolean().optional()
  }),
  relevantPanelCount: _zod.z.number().optional(),
  relevantPanels: _zod.z.array(_latest.relevantPanelSchema).optional()
});
const suggestedDashboardSchema = exports.suggestedDashboardSchema = _zod.z.object({
  id: _zod.z.string(),
  title: _zod.z.string(),
  description: _zod.z.string(),
  matchedBy: _zod.z.object({
    fields: _zod.z.array(_zod.z.string()).optional(),
    index: _zod.z.array(_zod.z.string()).optional()
  }),
  relevantPanelCount: _zod.z.number(),
  relevantPanels: _zod.z.array(_latest.relevantPanelSchema),
  score: _zod.z.number()
});