"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsSection = LogsSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _formatters = require("@elastic/charts/dist/utils/data/formatters");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _section_container = require("../section_container");
var _data_handler = require("../../../../../context/has_data_context/data_handler");
var _use_has_data = require("../../../../../hooks/use_has_data");
var _use_date_picker_context = require("../../../../../hooks/use_date_picker_context");
var _format_stat_value = require("../../../../../utils/format_stat_value");
var _chart_container = require("../../chart_container/chart_container");
var _styled_stat = require("../../styled_stat/styled_stat");
var _on_brush_end = require("../../../helpers/on_brush_end");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getColorPerItem(series) {
  if (!series) {
    return {};
  }
  const availableColors = (0, _eui.euiPaletteColorBlind)({
    rotations: Math.ceil(Object.keys(series).length / 10)
  });
  const colorsPerItem = Object.keys(series).reduce((acc, key, index) => {
    acc[key] = availableColors[index];
    return acc;
  }, {});
  return colorsPerItem;
}
function LogsSection({
  bucketSize
}) {
  var _hasDataMap$infra_log;
  const history = (0, _reactRouterDom.useHistory)();
  const chartThemes = (0, _public.useChartThemes)();
  const {
    forceUpdate,
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const {
    relativeStart,
    relativeEnd,
    absoluteStart,
    absoluteEnd,
    lastUpdated
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const {
    data,
    status
  } = (0, _public.useFetcher)(() => {
    if (bucketSize && absoluteStart && absoluteEnd) {
      var _getDataHandler;
      return (_getDataHandler = (0, _data_handler.getDataHandler)('infra_logs')) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.fetchData({
        absoluteTime: {
          start: absoluteStart,
          end: absoluteEnd
        },
        relativeTime: {
          start: relativeStart,
          end: relativeEnd
        },
        ...bucketSize
      });
    }
  },
  // `forceUpdate` and `lastUpdated` trigger a reload

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [bucketSize, relativeStart, relativeEnd, absoluteStart, absoluteEnd, forceUpdate, lastUpdated]);
  if (!((_hasDataMap$infra_log = hasDataMap.infra_logs) !== null && _hasDataMap$infra_log !== void 0 && _hasDataMap$infra_log.hasData)) {
    return null;
  }
  const min = _moment.default.utc(absoluteStart).valueOf();
  const max = _moment.default.utc(absoluteEnd).valueOf();
  const formatter = bucketSize !== null && bucketSize !== void 0 && bucketSize.dateFormat ? (0, _formatters.timeFormatter)(bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) : (0, _charts.niceTimeFormatter)([min, max]);
  const {
    appLink,
    stats,
    series
  } = data || {};
  const colorsPerItem = getColorPerItem(series);
  const isLoading = status === _public.FETCH_STATUS.LOADING;
  return /*#__PURE__*/_react.default.createElement(_section_container.SectionContainer, {
    title: _i18n.i18n.translate('xpack.observability.overview.logs.title', {
      defaultMessage: 'Log Events'
    }),
    appLink: {
      href: appLink,
      label: _i18n.i18n.translate('xpack.observability.overview.logs.appLink', {
        defaultMessage: 'Show Logs Explorer'
      }),
      prependBasePath: false
    },
    hasError: status === _public.FETCH_STATUS.FAILURE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.observability.overview.logs.subtitle', {
    defaultMessage: 'Logs rate per minute'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, !stats || (0, _lodash.isEmpty)(stats) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_styled_stat.StyledStat, {
    isLoading: isLoading
  })) : Object.keys(stats).map(key => {
    const stat = stats[key];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: key
    }, /*#__PURE__*/_react.default.createElement(_styled_stat.StyledStat, {
      title: (0, _format_stat_value.formatStatValue)(stat),
      description: stat.label,
      isLoading: isLoading,
      color: colorsPerItem[key]
    }));
  })), /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    isInitialLoad: isLoading && !data
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    onBrushEnd: event => (0, _on_brush_end.onBrushEnd)({
      x: event.x,
      history
    })
  }, chartThemes, {
    showLegend: true,
    legendPosition: _charts.Position.Right,
    xDomain: {
      min,
      max
    },
    locale: _i18n.i18n.getLocale()
  })), series && Object.keys(series).map(key => {
    const serie = series[key];
    const chartData = serie.coordinates.map(coordinate => ({
      ...coordinate,
      g: serie.label
    }));
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      id: key,
      xScaleType: _charts.ScaleType.Time,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: 'x',
      yAccessors: ['y'],
      stackAccessors: ['x'],
      splitSeriesAccessors: ['g'],
      data: chartData,
      color: colorsPerItem[key]
    }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
      id: "x-axis",
      position: _charts.Position.Bottom,
      showOverlappingTicks: false,
      showOverlappingLabels: false,
      tickFormat: formatter
    }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
      id: "y-axis",
      gridLine: {
        visible: true
      },
      position: _charts.Position.Left,
      tickFormat: d => (0, _numeral.default)(d).format('0a')
    }));
  })));
}