"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardTile = DashboardTile;
var _react = _interopRequireDefault(require("react"));
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _eui = require("@elastic/eui");
var _kibana_react = require("../../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DashboardTile({
  dashboard,
  actionButtonProps
}) {
  const {
    services: {
      share: {
        url: urlService
      }
    }
  } = (0, _kibana_react.useKibana)();
  const dashboardLocator = urlService.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    key: dashboard.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: dashboard.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11yDashboardTileLink",
    href: dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
      dashboardId: dashboard.id
    }),
    target: "_blank"
  }, dashboard.title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: 'subdued',
    size: "s"
  }, dashboard.description)), actionButtonProps ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `addSuggestedDashboard_alertDetailsPage_${actionButtonProps.ruleType}`,
    onClick: () => actionButtonProps.onClick(dashboard),
    isLoading: actionButtonProps.isLoading,
    isDisabled: actionButtonProps.isDisabled,
    iconType: "plus"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, actionButtonProps.label))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }));
}