"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAlertsTable = RelatedAlertsTable;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _get_related_columns = require("./get_related_columns");
var _get_build_related_alerts_query = require("../../hooks/related_alerts/get_build_related_alerts_query");
var _ = require("../../../..");
var _use_plugin_context = require("../../../../hooks/use_plugin_context");
var _kibana_react = require("../../../../utils/kibana_react");
var _alerts_flyout_body = require("../../../../components/alerts_flyout/alerts_flyout_body");
var _alerts_flyout_footer = require("../../../../components/alerts_flyout/alerts_flyout_footer");
var _constants = require("../../../../../common/constants");
var _cell_value = require("../../../../components/alerts_table/common/cell_value");
var _common = require("../../../../../common");
var _use_filter_proximal_param = require("../../hooks/use_filter_proximal_param");
var _related_alerts_table_filter = require("./related_alerts_table_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columns = (0, _get_related_columns.getRelatedColumns)();
const initialSort = [{
  _score: {
    order: 'desc'
  }
}, {
  [_ruleDataUtils.ALERT_START]: {
    order: 'desc'
  }
}, {
  [_ruleDataUtils.ALERT_UUID]: {
    order: 'desc'
  }
}];
const caseConfiguration = {
  featureId: _common.casesFeatureIdV2,
  owner: [_.observabilityFeatureId]
};
const RELATED_ALERTS_TABLE_ID = 'xpack.observability.alerts.relatedAlerts';
function RelatedAlertsTable({
  alertData
}) {
  const {
    formatted: alert
  } = alertData;
  const {
    filterProximal
  } = (0, _use_filter_proximal_param.useFilterProximalParam)();
  const esQuery = (0, _get_build_related_alerts_query.getBuildRelatedAlertsQuery)({
    alert,
    filterProximal
  });
  const {
    observabilityRuleTypeRegistry,
    config
  } = (0, _use_plugin_context.usePluginContext)();
  const services = (0, _kibana_react.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_related_alerts_table_filter.RelatedAlertsTableFilter, null), /*#__PURE__*/_react.default.createElement(_responseOpsAlertsTable.AlertsTable, {
    id: RELATED_ALERTS_TABLE_ID,
    query: esQuery,
    columns: columns,
    ruleTypeIds: _constants.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    minScore: 1.5,
    trackScores: true,
    initialSort: initialSort,
    casesConfiguration: caseConfiguration,
    additionalContext: {
      observabilityRuleTypeRegistry,
      config,
      parentAlert: alert
    },
    toolbarVisibility: {
      showSortSelector: false
    },
    renderCellValue: _cell_value.AlertsTableCellValue,
    renderFlyoutBody: _alerts_flyout_body.AlertsFlyoutBody,
    renderFlyoutFooter: _alerts_flyout_footer.AlertsFlyoutFooter,
    showAlertStatusWithFlapping: true,
    services: services,
    gridStyle: {
      border: 'horizontal',
      header: 'underline',
      cellPadding: 'l',
      fontSize: 'm'
    },
    rowHeightsOptions: {
      defaultHeight: 'auto'
    },
    height: "600px",
    emptyState: {
      messageTitle: _i18n.i18n.translate('xpack.observability.relatedAlertsTable.emptyState.title', {
        defaultMessage: 'No related alerts found'
      }),
      messageBody: _i18n.i18n.translate('xpack.observability.relatedAlertsTable.emptyState.body', {
        defaultMessage: 'No existing alerts match our related alerts criteria at this time. This may change if more alerts appear, so you may want to check back later.'
      })
    }
  }));
}