"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = HeaderActions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _common = require("@kbn/cases-plugin/common");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _kibana_react = require("../../../utils/kibana_react");
var _paths = require("../../../../common/locators/paths");
var _use_bulk_untrack_alerts = require("../hooks/use_bulk_untrack_alerts");
var _AlertDetailsRuleFormFlyout = require("./AlertDetailsRuleFormFlyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderActions({
  alert,
  alertIndex,
  alertStatus,
  onUntrackAlert,
  onUpdate,
  rule,
  refetch
}) {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    cases: {
      hooks: {
        useCasesAddToExistingCaseModal
      }
    },
    triggersActionsUi: {
      getRuleSnoozeModal: RuleSnoozeModal
    },
    http
  } = services;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [snoozeModalOpen, setSnoozeModalOpen] = (0, _react.useState)(false);
  const selectCaseModal = useCasesAddToExistingCaseModal();
  const {
    mutateAsync: untrackAlerts
  } = (0, _use_bulk_untrack_alerts.useBulkUntrackAlerts)();
  const handleUntrackAlert = (0, _react.useCallback)(async () => {
    if (alert) {
      await untrackAlerts({
        indices: ['.internal.alerts-observability.*'],
        alertUuids: [alert.fields[_ruleDataUtils.ALERT_UUID]]
      });
      onUntrackAlert();
    }
  }, [alert, untrackAlerts, onUntrackAlert]);
  const [alertDetailsRuleFormFlyoutOpen, setAlertDetailsRuleFormFlyoutOpen] = (0, _react.useState)(false);
  const handleTogglePopover = () => setIsPopoverOpen(!isPopoverOpen);
  const handleClosePopover = () => setIsPopoverOpen(false);
  const attachments = alert && rule ? [{
    alertId: (alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_UUID]) || '',
    index: alertIndex || '',
    rule: {
      id: rule.id,
      name: rule.name
    },
    type: _common.AttachmentType.alert
  }] : [];
  const handleAddToCase = () => {
    setIsPopoverOpen(false);
    selectCaseModal.open({
      getAttachments: () => attachments
    });
  };
  const handleOpenSnoozeModal = () => {
    setIsPopoverOpen(false);
    setSnoozeModalOpen(true);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plus",
    onClick: handleAddToCase,
    disabled: !(alert !== null && alert !== void 0 && alert.fields[_ruleDataUtils.ALERT_RULE_UUID]) || !rule,
    "data-test-subj": "add-to-case-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alertDetails.addToCase', {
    defaultMessage: 'Add to case'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    isOpen: isPopoverOpen,
    closePopover: handleClosePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "m",
      iconType: "boxesVertical",
      "data-test-subj": "alert-details-header-actions-menu-button",
      onClick: handleTogglePopover,
      "aria-label": _i18n.i18n.translate('xpack.observability.alertDetails.actionsButtonLabel', {
        defaultMessage: 'Actions'
      })
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '220px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement("div", null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    iconType: "bellSlash",
    onClick: handleOpenSnoozeModal,
    disabled: !(alert !== null && alert !== void 0 && alert.fields[_ruleDataUtils.ALERT_RULE_UUID]) || !rule,
    "data-test-subj": "snooze-rule-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alertDetails.editSnoozeRule', {
    defaultMessage: 'Snooze the rule'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    iconType: "pencil",
    onClick: () => {
      setIsPopoverOpen(false);
      setAlertDetailsRuleFormFlyoutOpen(true);
    },
    disabled: !(alert !== null && alert !== void 0 && alert.fields[_ruleDataUtils.ALERT_RULE_UUID]) || !rule,
    "data-test-subj": "edit-rule-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alertDetails.editRule', {
    defaultMessage: 'Edit rule'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    iconType: "eyeClosed",
    onClick: handleUntrackAlert,
    "data-test-subj": "untrack-alert-button",
    disabled: alertStatus !== _ruleDataUtils.ALERT_STATUS_ACTIVE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alertDetails.untrackAlert', {
    defaultMessage: 'Mark as untracked'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    iconType: "link",
    disabled: !(alert !== null && alert !== void 0 && alert.fields[_ruleDataUtils.ALERT_RULE_UUID]) || !rule,
    "data-test-subj": "view-rule-details-button",
    href: rule ? http.basePath.prepend(_paths.paths.observability.ruleDetails(rule.id)) : '',
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alertDetails.viewRuleDetails', {
    defaultMessage: 'Go to rule details'
  }))), /*#__PURE__*/_react.default.createElement("div", null)))))), rule && /*#__PURE__*/_react.default.createElement(_AlertDetailsRuleFormFlyout.AlertDetailsRuleFormFlyout, {
    isRuleFormFlyoutOpen: alertDetailsRuleFormFlyoutOpen,
    setIsRuleFormFlyoutOpen: setAlertDetailsRuleFormFlyoutOpen,
    onUpdate: onUpdate,
    refetch: refetch,
    rule: rule
  }), rule && snoozeModalOpen ? /*#__PURE__*/_react.default.createElement(RuleSnoozeModal, {
    rule: rule,
    onClose: () => setSnoozeModalOpen(false),
    onRuleChanged: async () => {
      refetch();
    },
    onLoading: _lodash.noop
  }) : null);
}