"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertHistoryChart = AlertHistoryChart;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _formatters = require("../../../../common/utils/formatters");
var _kibana_react = require("../../../utils/kibana_react");
var _alert_summary_widget = require("../../../utils/alert_summary_widget");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dateRange = {
  from: 'now-30d',
  to: 'now+1d'
};
function AlertHistoryChart({
  rule,
  alert
}) {
  const {
    http,
    notifications,
    triggersActionsUi: {
      getAlertSummaryWidget: AlertSummaryWidget
    }
  } = (0, _kibana_react.useKibana)().services;
  const instanceId = alert.fields[_ruleDataUtils.ALERT_INSTANCE_ID];
  const ruleId = alert.fields[_ruleDataUtils.ALERT_RULE_UUID];
  const ruleTypeIds = [rule.ruleTypeId];
  const consumers = [rule.consumer];
  const {
    data: {
      avgTimeToRecoverUS,
      totalTriggeredAlerts
    },
    isLoading,
    isError
  } = (0, _observabilityAlertDetails.useAlertsHistory)({
    http,
    ruleTypeIds,
    consumers,
    ruleId: rule.id,
    dateRange,
    instanceId
  });
  if (isError) {
    notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addDanger({
      title: _i18n.i18n.translate('xpack.observability.alertDetailsPage.alertHistory.error.toastTitle', {
        defaultMessage: 'Alerts history chart error'
      }),
      text: _i18n.i18n.translate('xpack.observability.alertDetailsPage.alertHistory.error.toastDescription', {
        defaultMessage: `An error occurred when fetching alert history chart data`
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "AlertDetails"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.alertDetailsPage.alertHistory.chartTitle', {
    defaultMessage: 'Alerts history'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.observability.alertDetailsPage.alertHistory.last30days', {
    defaultMessage: 'Last 30 days'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : totalTriggeredAlerts || '-')))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.observability.alertDetailsPage.alertHistory.alertsTriggered', {
    defaultMessage: 'Alerts triggered'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : avgTimeToRecoverUS ? (0, _formatters.convertTo)({
    unit: 'minutes',
    microseconds: avgTimeToRecoverUS,
    extended: true
  }).formatted : '-')))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.observability.alertDetailsPage.alertHistory.avgTimeToRecover', {
    defaultMessage: 'Avg time to recover'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    ruleTypeIds: ruleTypeIds,
    consumers: consumers,
    timeRange: (0, _alert_summary_widget.getDefaultAlertSummaryTimeRange)(),
    fullSize: true,
    hideStats: true,
    filter: {
      bool: {
        must: [{
          term: {
            [_ruleDataUtils.ALERT_RULE_UUID]: ruleId
          }
        }, ...(instanceId && instanceId !== '*' ? [{
          term: {
            [_ruleDataUtils.ALERT_INSTANCE_ID]: instanceId
          }
        }] : [])]
      }
    }
  }));
}