"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOApplyTo = SLOApplyTo;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _slo_selector = require("./slo_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SLOApplyTo({
  editAnnotation
}) {
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationMeta.euiFormRow.sloLabel', {
      defaultMessage: 'SLOs'
    }),
    display: "columnCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: editAnnotation === null || editAnnotation === void 0 ? void 0 : editAnnotation.slo,
    name: "slo",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_slo_selector.SloSelector, {
      value: field.value,
      onSelected: newValue => {
        const {
          slo,
          all
        } = newValue;
        if (all) {
          field.onChange({
            id: _sloSchema.ALL_VALUE
          });
        } else {
          field.onChange(slo);
        }
      }
    })
  }));
}