"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmAppLocator = exports.APM_APP_LOCATOR_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APM_APP_LOCATOR_ID = exports.APM_APP_LOCATOR_ID = 'APM_LOCATOR';
const getApmLocatorParams = params => {
  return {
    serviceName: params.serviceName,
    serviceOverviewTab: params.serviceOverviewTab,
    query: {
      environment: params.environment,
      transactionType: params.transactionType,
      transactionName: params.transactionName,
      rangeFrom: params.rangeFrom,
      rangeTo: params.rangeTo
    }
  };
};
const getApmAppLocator = baseLocator => {
  if (!baseLocator) return;
  return {
    ...baseLocator,
    getRedirectUrl: params => baseLocator.getRedirectUrl(getApmLocatorParams(params)),
    navigate: params => baseLocator.navigate(getApmLocatorParams(params))
  };
};
exports.getApmAppLocator = getApmAppLocator;