"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggType = exports.ThresholdFormatterTypeRT = exports.QUERY_INVALID = exports.MetricsExplorerChartType = exports.InfraFormatterType = exports.AlertStates = exports.Aggregators = void 0;
exports.fromEnum = fromEnum;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThresholdFormatterTypeRT = exports.ThresholdFormatterTypeRT = rt.keyof({
  abbreviatedNumber: null,
  bits: null,
  bytes: null,
  number: null,
  percent: null,
  highPrecision: null
});
let Aggregators = exports.Aggregators = /*#__PURE__*/function (Aggregators) {
  Aggregators["COUNT"] = "count";
  Aggregators["AVERAGE"] = "avg";
  Aggregators["SUM"] = "sum";
  Aggregators["MIN"] = "min";
  Aggregators["MAX"] = "max";
  Aggregators["CARDINALITY"] = "cardinality";
  Aggregators["RATE"] = "rate";
  Aggregators["P95"] = "p95";
  Aggregators["P99"] = "p99";
  Aggregators["LAST_VALUE"] = "last_value";
  return Aggregators;
}({});
const aggType = exports.aggType = fromEnum('Aggregators', Aggregators);
let MetricsExplorerChartType = exports.MetricsExplorerChartType = /*#__PURE__*/function (MetricsExplorerChartType) {
  MetricsExplorerChartType["line"] = "line";
  MetricsExplorerChartType["area"] = "area";
  MetricsExplorerChartType["bar"] = "bar";
  return MetricsExplorerChartType;
}({});
let AlertStates = exports.AlertStates = /*#__PURE__*/function (AlertStates) {
  AlertStates[AlertStates["OK"] = 0] = "OK";
  AlertStates[AlertStates["ALERT"] = 1] = "ALERT";
  AlertStates[AlertStates["WARNING"] = 2] = "WARNING";
  AlertStates[AlertStates["NO_DATA"] = 3] = "NO_DATA";
  AlertStates[AlertStates["ERROR"] = 4] = "ERROR";
  return AlertStates;
}({}); // Types for the executor
const QUERY_INVALID = exports.QUERY_INVALID = Symbol('QUERY_INVALID');
let InfraFormatterType = exports.InfraFormatterType = /*#__PURE__*/function (InfraFormatterType) {
  InfraFormatterType["number"] = "number";
  InfraFormatterType["abbreviatedNumber"] = "abbreviatedNumber";
  InfraFormatterType["bytes"] = "bytes";
  InfraFormatterType["bits"] = "bits";
  InfraFormatterType["percent"] = "percent";
  return InfraFormatterType;
}({});
/*
 * Utils
 *
 * This utility function can be used to turn a TypeScript enum into a io-ts codec.
 */
function fromEnum(enumName, theEnum) {
  const isEnumValue = input => Object.values(theEnum).includes(input);
  return new rt.Type(enumName, isEnumValue, (input, context) => isEnumValue(input) ? rt.success(input) : rt.failure(input, context), rt.identity);
}