"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kubernetesOnboardingRouteRepository = void 0;
var _uuid = require("uuid");
var t = _interopRequireWildcard(require("io-ts"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _server = require("@kbn/observability-plugin/server");
var _get_fallback_urls = require("../../lib/get_fallback_urls");
var _create_observability_onboarding_server_route = require("../create_observability_onboarding_server_route");
var _has_log_monitoring_privileges = require("../../lib/api_key/has_log_monitoring_privileges");
var _create_shipper_api_key = require("../../lib/api_key/create_shipper_api_key");
var _get_agent_version = require("../../lib/get_agent_version");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createKubernetesOnboardingFlowRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'POST /internal/observability_onboarding/kubernetes/flow',
  params: t.type({
    body: t.intersection([t.type({
      pkgName: t.union([t.literal('kubernetes'), t.literal('kubernetes_otel')])
    }), t.partial({
      agentVersionPattern: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler({
    context,
    request,
    params,
    plugins,
    services,
    kibanaVersion
  }) {
    var _plugins$cloud, _plugins$cloud$setup, _plugins$cloud2, _plugins$cloud2$setup;
    const {
      elasticsearch: {
        client
      }
    } = await context.core;
    const hasPrivileges = await (0, _has_log_monitoring_privileges.hasLogMonitoringPrivileges)(client.asCurrentUser, true);
    if (!hasPrivileges) {
      throw _boom.default.forbidden("You don't have enough privileges to start a new onboarding flow. Contact your system administrator to grant you the required privileges.");
    }
    const fleetPluginStart = await plugins.fleet.start();
    const packageClient = fleetPluginStart.packageService.asScoped(request);
    const [{
      encoded: apiKeyEncoded
    }, elasticAgentVersionInfo] = await Promise.all([(0, _create_shipper_api_key.createShipperApiKey)(client.asCurrentUser, params.body.pkgName === 'kubernetes_otel' ? 'otel-kubernetes' : 'kubernetes', true), (0, _get_agent_version.getAgentVersionInfo)(fleetPluginStart, kibanaVersion, params.body.agentVersionPattern),
    // System package is always required
    packageClient.ensureInstalledPackage({
      pkgName: 'system'
    }),
    // Kubernetes package is required for both classic kubernetes and otel
    packageClient.ensureInstalledPackage({
      pkgName: 'kubernetes'
    }),
    // Kubernetes otel package is required only for otel
    params.body.pkgName === 'kubernetes_otel' ? packageClient.ensureInstalledPackage({
      pkgName: 'kubernetes_otel'
    }) : undefined]);
    const elasticsearchUrlList = (_plugins$cloud = plugins.cloud) !== null && _plugins$cloud !== void 0 && (_plugins$cloud$setup = _plugins$cloud.setup) !== null && _plugins$cloud$setup !== void 0 && _plugins$cloud$setup.elasticsearchUrl ? [(_plugins$cloud2 = plugins.cloud) === null || _plugins$cloud2 === void 0 ? void 0 : (_plugins$cloud2$setup = _plugins$cloud2.setup) === null || _plugins$cloud2$setup === void 0 ? void 0 : _plugins$cloud2$setup.elasticsearchUrl] : await (0, _get_fallback_urls.getFallbackESUrl)(services.esLegacyConfigService);
    return {
      onboardingId: (0, _uuid.v4)(),
      apiKeyEncoded,
      elasticsearchUrl: elasticsearchUrlList.length > 0 ? elasticsearchUrlList[0] : '',
      elasticAgentVersionInfo
    };
  }
});
const hasKubernetesDataRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/kubernetes/{onboardingId}/has-data',
  params: t.type({
    path: t.type({
      onboardingId: t.string
    })
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      onboardingId
    } = resources.params.path;
    const {
      elasticsearch
    } = await resources.context.core;
    try {
      const result = await elasticsearch.client.asCurrentUser.search({
        index: ['logs-*', 'metrics-*'],
        ignore_unavailable: true,
        size: 0,
        terminate_after: 1,
        query: {
          bool: {
            filter: (0, _server.termQuery)('fields.onboarding_id', onboardingId)
          }
        }
      });
      const {
        value
      } = result.hits.total;
      return {
        hasData: value > 0
      };
    } catch (error) {
      throw _boom.default.internal(`Elasticsearch responses with an error. ${error.message}`);
    }
  }
});
const kubernetesOnboardingRouteRepository = exports.kubernetesOnboardingRouteRepository = {
  ...createKubernetesOnboardingFlowRoute,
  ...hasKubernetesDataRoute
};