"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionalFormRow = OptionalFormRow;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function OptionalFormRow(props) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    label,
    children,
    helpText
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: {
      '.euiFormLabel': {
        width: '100%'
      },
      '.euiFormLabel > .euiFlexGroup > div:last-of-type': {
        fontWeight: 'normal',
        color: euiTheme.colors.subduedText
      }
    },
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.observability_onboarding.form.optional', {
      defaultMessage: 'Optional'
    }))),
    helpText: helpText
  }, children);
}