"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExistingDataCallout = ExistingDataCallout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExistingDataCallout() {
  const isMobile = (0, _eui.useIsWithinMaxBreakpoint)('s');
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      maxWidth: isMobile ? '100%' : '80%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.firehose.existingDataCallout.title', {
      defaultMessage: 'This workflow has been used before.'
    }),
    iconType: "info",
    color: "warning",
    "data-test-subj": "observabilityOnboardingFirehosePanelExistingDataCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.firehose.existingDataCallout.description', {
    defaultMessage: `If the Amazon Firehose Data stream(s) associated with this workflow are still active, you will encounter errors during onboarding. Navigate to Step 3 below in order to explore your services.`
  }))));
}