"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOnboardingStatus = getOnboardingStatus;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the current status of the onboarding flow:
 *
 * - `notStarted`: No progress has been made.
 * - `inProgress`: The user is running the installation command on the host.
 * - `awaitingData`: The installation has completed and we are waiting for data to be ingested.
 * - `dataReceived`: Data has been ingested - The Agent is up and running.
 */
function getOnboardingStatus(data) {
  var _data$progress$logsI, _data$progress$logsI2;
  if (!data) {
    return 'notStarted';
  }
  return ((_data$progress$logsI = data.progress['logs-ingest']) === null || _data$progress$logsI === void 0 ? void 0 : _data$progress$logsI.status) === 'complete' ? 'dataReceived' : ((_data$progress$logsI2 = data.progress['logs-ingest']) === null || _data$progress$logsI2 === void 0 ? void 0 : _data$progress$logsI2.status) === 'loading' ? 'awaitingData' : Object.values(data.progress).some(step => step.status !== 'incomplete') ? 'inProgress' : 'notStarted';
}