"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityLogsExplorerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _rxjs = require("rxjs");
var _locators = require("../common/locators");
var _data_view_locator = require("../common/locators/data_view_locator");
var _telemetry_events = require("../common/telemetry_events");
var _translations = require("../common/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ObservabilityLogsExplorerPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "locators", void 0);
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
  }
  setup(core, _pluginsSetup) {
    const {
      discover,
      share
    } = _pluginsSetup;
    const useHash = core.uiSettings.get('state:storeInSessionStorage');
    core.application.register({
      id: _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID,
      title: _translations.logsExplorerAppTitle,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      euiIconType: 'logoLogging',
      visibleIn: ['globalSearch'],
      keywords: ['logs', 'log', 'explorer', 'logs explorer'],
      updater$: this.appStateUpdater,
      mount: async appMountParams => {
        const [coreStart, pluginsStart, ownPluginStart] = await core.getStartServices();
        const {
          renderObservabilityLogsExplorer
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/observability_logs_explorer')));
        return renderObservabilityLogsExplorer(coreStart, pluginsStart, ownPluginStart, appMountParams);
      }
    });

    // ensure the tabs are shown when in the observability nav mode
    discover.configureInlineTopNav('oblt', {
      enabled: true,
      showLogsExplorerTabs: true
    });

    // App used solely to redirect from "/app/observability-log-explorer" to "/app/observability-logs-explorer"
    core.application.register({
      id: 'observability-log-explorer',
      title: _translations.logsExplorerAppTitle,
      visibleIn: [],
      mount: async appMountParams => {
        const [coreStart] = await core.getStartServices();
        const {
          renderObservabilityLogsExplorerRedirect
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/redirect_to_observability_logs_explorer')));
        return renderObservabilityLogsExplorerRedirect(coreStart, appMountParams);
      }
    });

    // App used solely to redirect to either "/app/observability-logs-explorer" or "/app/discover"
    // based on the last used app value in localStorage
    core.application.register({
      id: 'last-used-logs-viewer',
      title: _translations.logsExplorerAppTitle,
      visibleIn: [],
      mount: async appMountParams => {
        const [coreStart] = await core.getStartServices();
        const {
          renderLastUsedLogsViewerRedirect
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/last_used_logs_viewer')));
        return renderLastUsedLogsViewerRedirect(coreStart, appMountParams);
      }
    });
    core.analytics.registerEventType(_telemetry_events.DATA_RECEIVED_TELEMETRY_EVENT);

    // Register Locators
    const allDatasetsLocator = share.url.locators.create(new _locators.AllDatasetsLocatorDefinition({
      useHash
    }));
    const dataViewLocator = share.url.locators.create(new _data_view_locator.DataViewLocatorDefinition({
      useHash
    }));
    const singleDatasetLocator = share.url.locators.create(new _locators.SingleDatasetLocatorDefinition({
      useHash
    }));
    this.locators = {
      allDatasetsLocator,
      dataViewLocator,
      singleDatasetLocator
    };
    return {
      locators: this.locators
    };
  }
  start(core, _pluginsStart) {
    const {
      discover,
      fleet,
      logs
    } = core.application.capabilities;
    if (!(discover !== null && discover !== void 0 && discover.show && fleet !== null && fleet !== void 0 && fleet.read && logs !== null && logs !== void 0 && logs.show)) {
      this.appStateUpdater.next(() => ({
        status: _public.AppStatus.inaccessible,
        visibleIn: []
      }));
    }
    return {};
  }
}
exports.ObservabilityLogsExplorerPlugin = ObservabilityLogsExplorerPlugin;