"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogsExplorerControllerWithCustomizations = void 0;
var _discover_navigation_handler = require("./discover_navigation_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLogsExplorerControllerWithCustomizations = (createLogsExplorerController, services) => args => createLogsExplorerController({
  ...args,
  customizations: {
    ...args.customizations,
    events: {
      onUknownDataViewSelection: (0, _discover_navigation_handler.createOnUknownDataViewSelectionHandler)(services.discover)
    }
  }
});
exports.createLogsExplorerControllerWithCustomizations = createLogsExplorerControllerWithCustomizations;