"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react2 = require("@xstate/react");
var _common = require("@kbn/logs-explorer-plugin/common");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/logs-explorer-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _common2 = require("@kbn/observability-shared-plugin/common");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _reactHooks = require("@kbn/react-hooks");
var _lib = require("@kbn/response-ops-rule-form/lib");
var _get_rule_types = require("@kbn/response-ops-rules-apis/apis/get_rule_types");
var _use_kibana = require("../utils/use_kibana");
var _src = require("../state_machines/observability_logs_explorer/src");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultQuery = {
  language: 'kuery',
  query: ''
};
function getQuery(query) {
  if (query && (0, _esQuery.isOfQueryType)(query)) {
    return query;
  }
  return defaultQuery;
}
const AlertsPopover = () => {
  var _application$capabili;
  const {
    services: {
      triggersActionsUi,
      slo,
      ...services
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    application,
    http
  } = services;
  const manageRulesLinkProps = (0, _public2.useLinkProps)({
    app: 'observability',
    pathname: '/alerts/rules'
  });
  const [pageState] = (0, _react2.useActor)((0, _src.useObservabilityLogsExplorerPageStateContext)());
  const [isPopoverOpen, {
    toggle: togglePopover,
    off: closePopover
  }] = (0, _reactHooks.useBoolean)();
  const [isAddRuleFlyoutOpen, {
    on: openAddRuleFlyout,
    off: closeAddRuleFlyout
  }] = (0, _reactHooks.useBoolean)();
  const [isCreateSLOFlyoutOpen, {
    on: openCreateSLOFlyout,
    off: closeCreateSLOFlyout
  }] = (0, _reactHooks.useBoolean)();
  const addRuleFlyout = (0, _react.useMemo)(() => {
    if (isAddRuleFlyoutOpen && triggersActionsUi && (0, _lib.isValidRuleFormPlugins)(services) && pageState.matches({
      initialized: 'validLogsExplorerState'
    })) {
      const {
        logsExplorerState
      } = pageState.context;
      const index = (0, _common.hydrateDataSourceSelection)(logsExplorerState.dataSourceSelection, pageState.context.allSelection).toDataviewSpec();
      const {
        ruleTypeRegistry,
        actionTypeRegistry
      } = triggersActionsUi;
      return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
        plugins: {
          ...services,
          ruleTypeRegistry,
          actionTypeRegistry
        },
        consumer: "logs",
        ruleTypeId: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
        initialValues: {
          params: {
            searchConfiguration: {
              index,
              query: getQuery(logsExplorerState.query),
              filter: (0, _public.getDiscoverFiltersFromState)(index.id, logsExplorerState.filters, logsExplorerState.controls)
            }
          }
        },
        onSubmit: closeAddRuleFlyout,
        onCancel: closeAddRuleFlyout
      });
    }
  }, [closeAddRuleFlyout, triggersActionsUi, pageState, isAddRuleFlyoutOpen, services]);
  const createSLOFlyout = (0, _react.useMemo)(() => {
    if (isCreateSLOFlyoutOpen && pageState.matches({
      initialized: 'validLogsExplorerState'
    })) {
      var _logsExplorerState$ch;
      const {
        logsExplorerState
      } = pageState.context;
      const dataView = (0, _common.hydrateDataSourceSelection)(logsExplorerState.dataSourceSelection, pageState.context.allSelection).toDataviewSpec();
      const query = logsExplorerState !== null && logsExplorerState !== void 0 && logsExplorerState.query && 'query' in logsExplorerState.query ? String(logsExplorerState.query.query) : undefined;
      return slo.getCreateSLOFlyout({
        initialValues: {
          indicator: {
            type: 'sli.kql.custom',
            params: {
              index: dataView.title,
              timestampField: dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName,
              filter: {
                kqlQuery: query,
                filters: (0, _public.getDiscoverFiltersFromState)(dataView.id, logsExplorerState.filters, logsExplorerState.controls)
              }
            }
          },
          groupBy: (_logsExplorerState$ch = logsExplorerState.chart.breakdownField) !== null && _logsExplorerState$ch !== void 0 ? _logsExplorerState$ch : undefined
        },
        onClose: closeCreateSLOFlyout
      });
    }
  }, [isCreateSLOFlyoutOpen, pageState, slo, closeCreateSLOFlyout]);

  // Check whether the user has the necessary permissions to create an SLO
  const canCreateSLOs = !!((_application$capabili = application.capabilities[_common2.sloFeatureId]) !== null && _application$capabili !== void 0 && _application$capabili.write);

  // Check whether the user has the necessary permissions to create a rule
  const canCreateRuleState = (0, _useAsync.default)(async () => {
    const ruleTypes = await (0, _get_rule_types.getRuleTypes)({
      http
    });
    const customThresholdRuleType = ruleTypes.find(ruleType => ruleType.id === _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID);
    if (customThresholdRuleType) {
      var _customThresholdRuleT;
      return (_customThresholdRuleT = customThresholdRuleType.authorizedConsumers.logs) === null || _customThresholdRuleT === void 0 ? void 0 : _customThresholdRuleT.all;
    }
    return false;
  });
  const items = [];
  if (canCreateRuleState.value) {
    items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createRule",
      icon: "bell",
      onClick: openAddRuleFlyout
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observabilityLogsExplorer.alertsPopover.createRuleMenuItem",
      defaultMessage: "Create rule"
    })));
  }
  if (canCreateSLOs) {
    items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createSLO",
      icon: "visGauge",
      onClick: openCreateSLOFlyout
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observabilityLogsExplorer.alertsPopover.createSLOMenuItem",
      defaultMessage: "Create SLO"
    })));
  }
  if (items.length > 0) {
    items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      key: "horizontalRule",
      margin: "none"
    }));
  }
  items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    key: "manageRules",
    icon: "tableOfContents"
  }, manageRulesLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityLogsExplorer.alertsPopover.manageRulesMenuItem",
    defaultMessage: "{canCreateRule, select, true{Manage} other{View}} rules",
    values: {
      canCreateRule: canCreateRuleState.value
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, addRuleFlyout, createSLOFlyout, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "observabilityLogsExplorerAlertsPopoverAlertsButton",
      onClick: togglePopover,
      iconType: "arrowDown",
      iconSide: "right",
      isLoading: canCreateRuleState.loading
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observabilityLogsExplorer.alertsPopover.buttonLabel",
      defaultMessage: "Alerts"
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    onClick: closePopover,
    items: items
  })));
};
exports.AlertsPopover = AlertsPopover;