"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  urlSchemaRT: true
};
exports.urlSchemaRT = void 0;
var _common = require("@kbn/logs-explorer-plugin/common");
var rt = _interopRequireWildcard(require("io-ts"));
var _url_schema_v = require("./url_schema_v1");
Object.keys(_url_schema_v).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _url_schema_v[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _url_schema_v[key];
    }
  });
});
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The breaking change and only difference between url schema v1 to v2
 * is the renaming of the `datasetSelection` param to `dataSourceSelection`
 * as the selection parameter now represents a wider concept after the support to data views.
 */
const urlSchemaRT = exports.urlSchemaRT = rt.exact(rt.partial({
  v: rt.literal(2),
  breakdownField: rt.union([rt.string, rt.null]),
  columns: _url_schema_v.columnsRT,
  dataSourceSelection: _common.dataSourceSelectionPlainRT,
  filters: _url_schema_v.filtersRT,
  query: _url_schema_v.queryRT,
  refreshInterval: _url_schema_v.refreshIntervalRT,
  rowHeight: rt.number,
  rowsPerPage: rt.number,
  time: _url_schema_v.timeRangeRT,
  controls: _url_schema_v.controlsRT
}));