"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOrUpdateConversationIndexAssets = createOrUpdateConversationIndexAssets;
var _server = require("@kbn/alerting-plugin/server");
var _conversation_component_template = require("./templates/conversation_component_template");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createOrUpdateConversationIndexAssets({
  logger,
  core
}) {
  try {
    logger.debug('Setting up index assets');
    const [coreStart] = await core.getStartServices();
    const {
      asInternalUser
    } = coreStart.elasticsearch.client;

    // Conversations: component template
    await asInternalUser.cluster.putComponentTemplate({
      create: false,
      name: _.resourceNames.componentTemplate.conversations,
      template: _conversation_component_template.conversationComponentTemplate
    });

    // Conversations: index template
    await asInternalUser.indices.putIndexTemplate({
      name: _.resourceNames.indexTemplate.conversations,
      composed_of: [_.resourceNames.componentTemplate.conversations],
      create: false,
      index_patterns: [_.resourceNames.indexPatterns.conversations],
      template: {
        settings: {
          number_of_shards: 1,
          auto_expand_replicas: '0-1',
          hidden: true
        }
      }
    });

    // Conversations: write index
    const conversationAliasName = _.resourceNames.writeIndexAlias.conversations;
    await (0, _server.createConcreteWriteIndex)({
      esClient: asInternalUser,
      logger,
      totalFieldsLimit: 10000,
      indexPatterns: {
        alias: conversationAliasName,
        pattern: `${conversationAliasName}*`,
        basePattern: `${conversationAliasName}*`,
        name: _.resourceNames.concreteWriteIndexName.conversations,
        template: _.resourceNames.indexTemplate.conversations
      },
      dataStreamAdapter: (0, _server.getDataStreamAdapter)({
        useDataStreamForAlerts: false
      })
    });
    logger.info('Successfully set up conversation index assets');
  } catch (error) {
    logger.error(`Failed setting up conversation index assets: ${error.message}`);
    logger.debug(error);
  }
}