"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUsageCollector = registerUsageCollector;
var _service = require("../service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerUsageCollector(usageCollection, core) {
  if (!usageCollection) {
    return;
  }
  const usageCollector = usageCollection.makeUsageCollector({
    type: 'observability_ai_assistant',
    isReady: () => true,
    schema: {
      knowledge_base: {
        users_with_any_entries: {
          type: 'long',
          _meta: {
            description: 'Number of unique users with any knowledge base entries'
          }
        },
        users_with_global_entries: {
          type: 'long',
          _meta: {
            description: 'Number of users with global knowledge base entries'
          }
        },
        users_with_global_entries_user_created: {
          type: 'long',
          _meta: {
            description: 'Number of users with global knowledge base entries created by user'
          }
        },
        users_with_global_entries_assistant_created: {
          type: 'long',
          _meta: {
            description: 'Number of users with global knowledge base entries created by assistant'
          }
        },
        users_with_private_entries: {
          type: 'long',
          _meta: {
            description: 'Number of users with private knowledge base entries'
          }
        },
        users_with_private_entries_user_created: {
          type: 'long',
          _meta: {
            description: 'Number of users with private knowledge base entries created by user'
          }
        },
        users_with_private_entries_assistant_created: {
          type: 'long',
          _meta: {
            description: 'Number of users with private knowledge base entries created by assistant'
          }
        },
        users_with_user_instructions: {
          type: 'long',
          _meta: {
            description: 'Number of users who have configured custom user instructions'
          }
        }
      },
      conversations: {
        users_with_archived_conversations: {
          type: 'long',
          _meta: {
            description: 'Number of users with archived conversations'
          }
        },
        users_with_private_conversations: {
          type: 'long',
          _meta: {
            description: 'Number of users with private conversations'
          }
        },
        users_with_shared_conversations: {
          type: 'long',
          _meta: {
            description: 'Number of users with shared conversations'
          }
        }
      }
    },
    fetch: async () => {
      var _value, _kbResponse$aggregati, _kbResponse$aggregati2, _value2, _kbResponse$aggregati3, _kbResponse$aggregati4, _kbResponse$aggregati5, _value3, _kbResponse$aggregati6, _kbResponse$aggregati7, _kbResponse$aggregati8, _value4, _kbResponse$aggregati9, _kbResponse$aggregati10, _kbResponse$aggregati11, _value5, _kbResponse$aggregati12, _kbResponse$aggregati13, _kbResponse$aggregati14, _value6, _kbResponse$aggregati15, _kbResponse$aggregati16, _kbResponse$aggregati17, _value7, _kbResponse$aggregati18, _kbResponse$aggregati19, _kbResponse$aggregati20, _value8, _kbResponse$aggregati21, _kbResponse$aggregati22, _kbResponse$aggregati23, _value9, _conversationsRespons, _conversationsRespons2, _conversationsRespons3, _value10, _conversationsRespons4, _conversationsRespons5, _conversationsRespons6, _value11, _conversationsRespons7, _conversationsRespons8, _conversationsRespons9;
      const [coreStart] = await core.getStartServices();
      const esClient = coreStart.elasticsearch.client.asInternalUser;
      const kbIndex = _service.resourceNames.indexPatterns.kb;
      const conversationsIndex = _service.resourceNames.indexPatterns.conversations;
      const kbResponse = await esClient.search({
        index: kbIndex,
        size: 0,
        query: {
          bool: {
            filter: [{
              exists: {
                field: 'user.id'
              }
            }]
          }
        },
        aggs: {
          any_entries: {
            cardinality: {
              field: 'user.id'
            }
          },
          global_entries: {
            filter: {
              term: {
                public: true
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          global_entries_user_created: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: true
                  }
                }, {
                  term: {
                    role: 'user_entry'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          global_entries_assistant_created: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: true
                  }
                }, {
                  term: {
                    role: 'assistant_summarization'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          private_entries: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: false
                  }
                }],
                must_not: [{
                  term: {
                    type: 'user_instruction'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          private_entries_user_created: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: false
                  }
                }, {
                  term: {
                    role: 'user_entry'
                  }
                }],
                must_not: [{
                  term: {
                    type: 'user_instruction'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          private_entries_assistant_created: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: false
                  }
                }, {
                  term: {
                    role: 'assistant_summarization'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          user_instructions: {
            filter: {
              term: {
                type: 'user_instruction'
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          }
        }
      });
      const conversationsResponse = await esClient.search({
        index: conversationsIndex,
        size: 0,
        query: {
          bool: {
            filter: [{
              exists: {
                field: 'user.id'
              }
            }]
          }
        },
        aggs: {
          archived: {
            filter: {
              term: {
                archived: true
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          private: {
            filter: {
              term: {
                public: false
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          shared: {
            filter: {
              term: {
                public: true
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          }
        }
      });
      return {
        knowledge_base: {
          users_with_any_entries: (_value = (_kbResponse$aggregati = kbResponse.aggregations) === null || _kbResponse$aggregati === void 0 ? void 0 : (_kbResponse$aggregati2 = _kbResponse$aggregati.any_entries) === null || _kbResponse$aggregati2 === void 0 ? void 0 : _kbResponse$aggregati2.value) !== null && _value !== void 0 ? _value : 0,
          users_with_global_entries: (_value2 = (_kbResponse$aggregati3 = kbResponse.aggregations) === null || _kbResponse$aggregati3 === void 0 ? void 0 : (_kbResponse$aggregati4 = _kbResponse$aggregati3.global_entries) === null || _kbResponse$aggregati4 === void 0 ? void 0 : (_kbResponse$aggregati5 = _kbResponse$aggregati4.unique_users) === null || _kbResponse$aggregati5 === void 0 ? void 0 : _kbResponse$aggregati5.value) !== null && _value2 !== void 0 ? _value2 : 0,
          users_with_global_entries_user_created: (_value3 = (_kbResponse$aggregati6 = kbResponse.aggregations) === null || _kbResponse$aggregati6 === void 0 ? void 0 : (_kbResponse$aggregati7 = _kbResponse$aggregati6.global_entries_user_created) === null || _kbResponse$aggregati7 === void 0 ? void 0 : (_kbResponse$aggregati8 = _kbResponse$aggregati7.unique_users) === null || _kbResponse$aggregati8 === void 0 ? void 0 : _kbResponse$aggregati8.value) !== null && _value3 !== void 0 ? _value3 : 0,
          users_with_global_entries_assistant_created: (_value4 = (_kbResponse$aggregati9 = kbResponse.aggregations) === null || _kbResponse$aggregati9 === void 0 ? void 0 : (_kbResponse$aggregati10 = _kbResponse$aggregati9.global_entries_assistant_created) === null || _kbResponse$aggregati10 === void 0 ? void 0 : (_kbResponse$aggregati11 = _kbResponse$aggregati10.unique_users) === null || _kbResponse$aggregati11 === void 0 ? void 0 : _kbResponse$aggregati11.value) !== null && _value4 !== void 0 ? _value4 : 0,
          users_with_private_entries: (_value5 = (_kbResponse$aggregati12 = kbResponse.aggregations) === null || _kbResponse$aggregati12 === void 0 ? void 0 : (_kbResponse$aggregati13 = _kbResponse$aggregati12.private_entries) === null || _kbResponse$aggregati13 === void 0 ? void 0 : (_kbResponse$aggregati14 = _kbResponse$aggregati13.unique_users) === null || _kbResponse$aggregati14 === void 0 ? void 0 : _kbResponse$aggregati14.value) !== null && _value5 !== void 0 ? _value5 : 0,
          users_with_private_entries_user_created: (_value6 = (_kbResponse$aggregati15 = kbResponse.aggregations) === null || _kbResponse$aggregati15 === void 0 ? void 0 : (_kbResponse$aggregati16 = _kbResponse$aggregati15.private_entries_user_created) === null || _kbResponse$aggregati16 === void 0 ? void 0 : (_kbResponse$aggregati17 = _kbResponse$aggregati16.unique_users) === null || _kbResponse$aggregati17 === void 0 ? void 0 : _kbResponse$aggregati17.value) !== null && _value6 !== void 0 ? _value6 : 0,
          users_with_private_entries_assistant_created: (_value7 = (_kbResponse$aggregati18 = kbResponse.aggregations) === null || _kbResponse$aggregati18 === void 0 ? void 0 : (_kbResponse$aggregati19 = _kbResponse$aggregati18.private_entries_assistant_created) === null || _kbResponse$aggregati19 === void 0 ? void 0 : (_kbResponse$aggregati20 = _kbResponse$aggregati19.unique_users) === null || _kbResponse$aggregati20 === void 0 ? void 0 : _kbResponse$aggregati20.value) !== null && _value7 !== void 0 ? _value7 : 0,
          users_with_user_instructions: (_value8 = (_kbResponse$aggregati21 = kbResponse.aggregations) === null || _kbResponse$aggregati21 === void 0 ? void 0 : (_kbResponse$aggregati22 = _kbResponse$aggregati21.user_instructions) === null || _kbResponse$aggregati22 === void 0 ? void 0 : (_kbResponse$aggregati23 = _kbResponse$aggregati22.unique_users) === null || _kbResponse$aggregati23 === void 0 ? void 0 : _kbResponse$aggregati23.value) !== null && _value8 !== void 0 ? _value8 : 0
        },
        conversations: {
          users_with_archived_conversations: (_value9 = (_conversationsRespons = conversationsResponse.aggregations) === null || _conversationsRespons === void 0 ? void 0 : (_conversationsRespons2 = _conversationsRespons.archived) === null || _conversationsRespons2 === void 0 ? void 0 : (_conversationsRespons3 = _conversationsRespons2.unique_users) === null || _conversationsRespons3 === void 0 ? void 0 : _conversationsRespons3.value) !== null && _value9 !== void 0 ? _value9 : 0,
          users_with_private_conversations: (_value10 = (_conversationsRespons4 = conversationsResponse.aggregations) === null || _conversationsRespons4 === void 0 ? void 0 : (_conversationsRespons5 = _conversationsRespons4.private) === null || _conversationsRespons5 === void 0 ? void 0 : (_conversationsRespons6 = _conversationsRespons5.unique_users) === null || _conversationsRespons6 === void 0 ? void 0 : _conversationsRespons6.value) !== null && _value10 !== void 0 ? _value10 : 0,
          users_with_shared_conversations: (_value11 = (_conversationsRespons7 = conversationsResponse.aggregations) === null || _conversationsRespons7 === void 0 ? void 0 : (_conversationsRespons8 = _conversationsRespons7.shared) === null || _conversationsRespons8 === void 0 ? void 0 : (_conversationsRespons9 = _conversationsRespons8.unique_users) === null || _conversationsRespons9 === void 0 ? void 0 : _conversationsRespons9.value) !== null && _value11 !== void 0 ? _value11 : 0
        }
      };
    }
  });
  usageCollection.registerCollector(usageCollector);
}