"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesType = void 0;
exports.registerLensRenderFunction = registerLensRenderFunction;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SeriesType = exports.SeriesType = /*#__PURE__*/function (SeriesType) {
  SeriesType["Bar"] = "bar";
  SeriesType["Line"] = "line";
  SeriesType["Area"] = "area";
  SeriesType["BarStacked"] = "bar_stacked";
  SeriesType["AreaStacked"] = "area_stacked";
  SeriesType["BarHorizontal"] = "bar_horizontal";
  SeriesType["BarPercentageStacked"] = "bar_percentage_stacked";
  SeriesType["AreaPercentageStacked"] = "area_percentage_stacked";
  SeriesType["BarHorizontalPercentageStacked"] = "bar_horizontal_percentage_stacked";
  return SeriesType;
}({});
function Lens({
  indexPattern,
  xyDataLayer,
  start,
  end,
  lens,
  dataViews,
  timeField
}) {
  const formulaAsync = (0, _useAsync.default)(() => {
    return lens.stateHelperApi();
  }, [lens]);
  const dataViewAsync = (0, _useAsync.default)(() => {
    return dataViews.create({
      title: indexPattern,
      timeFieldName: timeField
    });
  }, [indexPattern, dataViews, timeField]);
  const [isSaveModalOpen, setIsSaveModalOpen] = (0, _react.useState)(false);
  if (!formulaAsync.value || !dataViewAsync.value) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  const attributes = new _lensEmbeddableUtils.LensAttributesBuilder({
    visualization: new _lensEmbeddableUtils.XYChart({
      layers: [xyDataLayer],
      formulaAPI: formulaAsync.value.formula,
      dataView: dataViewAsync.value
    })
  }).build();
  const lensEmbeddableInput = {
    id: indexPattern,
    attributes,
    timeRange: {
      from: start,
      to: end,
      mode: 'relative'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantLensOpenInLensButton",
    iconType: "lensApp",
    onClick: () => {
      lens.navigateToPrefilledEditor(lensEmbeddableInput);
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.lensFunction.openInLens', {
    defaultMessage: 'Open in Lens'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantLensSaveButton",
    iconType: "save",
    onClick: () => {
      setIsSaveModalOpen(() => true);
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.lensFunction.save', {
    defaultMessage: 'Save'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, (0, _extends2.default)({}, lensEmbeddableInput, {
    style: {
      height: 240
    }
  })))), isSaveModalOpen ? /*#__PURE__*/_react.default.createElement(lens.SaveModalComponent, {
    initialInput: lensEmbeddableInput,
    onClose: () => {
      setIsSaveModalOpen(() => false);
    }
  }) : null);
}
function registerLensRenderFunction({
  registerRenderFunction,
  pluginsStart
}) {
  registerRenderFunction('lens', ({
    arguments: {
      layers,
      indexPattern,
      breakdown,
      seriesType,
      start,
      end,
      timeField
    }
  }) => {
    const xyDataLayer = new _lensEmbeddableUtils.XYDataLayer({
      data: layers.map(layer => {
        var _layer$filter;
        return {
          type: 'formula',
          value: layer.formula,
          label: layer.label,
          format: layer.format,
          filter: {
            language: 'kql',
            query: (_layer$filter = layer.filter) !== null && _layer$filter !== void 0 ? _layer$filter : ''
          }
        };
      }),
      options: {
        seriesType,
        breakdown: breakdown ? {
          type: 'top_values',
          params: {
            size: 10
          },
          field: breakdown.field
        } : undefined
      }
    });
    if (!timeField) return;
    return /*#__PURE__*/_react.default.createElement(Lens, {
      indexPattern: indexPattern,
      xyDataLayer: xyDataLayer,
      start: start,
      end: end,
      lens: pluginsStart.lens,
      dataViews: pluginsStart.dataViews,
      timeField: timeField
    });
  });
}