"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatementSection = StatementSection;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _statement_list_heading = require("./statement_list_heading");
var _eui = require("@elastic/eui");
var _statement_list = require("./statement_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StatementSection({
  iconType,
  headingText,
  elements,
  onShowVertexDetails
}) {
  if (!elements.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `pipelineViewerSection_${headingText}`
  }, /*#__PURE__*/_react.default.createElement(_statement_list_heading.StatementListHeading, {
    iconType: iconType,
    title: headingText
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_statement_list.StatementList, {
    elements: elements,
    onShowVertexDetails: onShowVertexDetails
  }));
}
StatementSection.propTypes = {
  elements: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    // top-level elements have null parentId
    parentId: _propTypes.default.string
  })).isRequired,
  headingText: _propTypes.default.string.isRequired,
  iconType: _propTypes.default.string.isRequired,
  onShowVertexDetails: _propTypes.default.func.isRequired
};