"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Metric = Metric;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
require("./metric.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Metric({
  className,
  warning,
  value
}) {
  const classes = (0, _classnames.default)('monPipelineViewer__metric', className);
  let stylizedValue;
  if (warning) {
    stylizedValue = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      className: className
    }, value);
  } else {
    stylizedValue = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      className: classes
    }, /*#__PURE__*/_react.default.createElement("span", null, value));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "monPipelineViewer__metricFlexItem",
    grow: false
  }, stylizedValue);
}
Metric.propTypes = {
  className: _propTypes.default.string.isRequired,
  value: _propTypes.default.string.isRequired,
  warning: _propTypes.default.bool
};