"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceTokens = replaceTokens;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _common = require("../../../common");
var _constants = require("../../../common/constants");
var _enums = require("../../../common/enums");
var _legacy_shims = require("../../legacy_shims");
var _get_safe_for_external_link = require("../../lib/get_safe_for_external_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function replaceTokens(alertMessage) {
  if (!alertMessage) {
    return null;
  }
  let text = alertMessage.text;
  if (!alertMessage.tokens || !alertMessage.tokens.length) {
    return text;
  }
  const timeTokens = alertMessage.tokens.filter(token => token.type === _enums.AlertMessageTokenType.Time);
  const linkTokens = alertMessage.tokens.filter(token => token.type === _enums.AlertMessageTokenType.Link);
  const docLinkTokens = alertMessage.tokens.filter(token => token.type === _enums.AlertMessageTokenType.DocLink);
  for (const token of timeTokens) {
    const timeToken = token;
    text = text.replace(timeToken.startToken, timeToken.isRelative ? (0, _common.formatTimestampToDuration)(timeToken.timestamp, _constants.CALCULATE_DURATION_UNTIL) : _moment.default.tz(timeToken.timestamp, _moment.default.tz.guess()).format('LLL z'));
  }
  let element = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, text);
  for (const token of linkTokens) {
    const linkToken = token;
    const linkPart = new RegExp(`${linkToken.startToken}(.+?)${linkToken.endToken}`).exec(text);
    if (!linkPart || linkPart.length < 2) {
      continue;
    }
    const index = text.indexOf(linkPart[0]);
    const preString = text.substring(0, index);
    const postString = text.substring(index + linkPart[0].length);
    const safeLink = (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/${linkToken.url}`);
    element = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, preString, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: safeLink
    }, linkPart[1]), postString);
  }
  for (const token of docLinkTokens) {
    const linkToken = token;
    const linkPart = new RegExp(`${linkToken.startToken}(.+?)${linkToken.endToken}`).exec(text);
    if (!linkPart || linkPart.length < 2) {
      continue;
    }
    const url = linkToken.partialUrl.replace('{basePath}', _legacy_shims.Legacy.shims.getBasePath()).replace('{elasticWebsiteUrl}', _legacy_shims.Legacy.shims.docLinks.ELASTIC_WEBSITE_URL).replace('{docLinkVersion}', _legacy_shims.Legacy.shims.docLinks.DOC_LINK_VERSION);
    const index = text.indexOf(linkPart[0]);
    const preString = text.substring(0, index);
    const postString = text.substring(index + linkPart[0].length);
    element = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, preString, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: url,
      target: "_blank",
      external: true
    }, linkPart[1]), postString);
  }
  return element;
}