"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertPanelsByNode = getAlertPanelsByNode;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _panel = require("../panel");
var _formatting = require("../../../common/formatting");
var _sort_by_newest_alert = require("./sort_by_newest_alert");
var _legacy_shims = require("../../legacy_shims");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAlertPanelsByNode(panelTitle, alerts, stateFilter) {
  const alertsByNodes = {};
  const statesByNodes = {};
  for (const {
    states,
    sanitizedRule
  } of alerts) {
    const {
      id: alertId
    } = sanitizedRule;
    for (const alertState of states.filter(({
      state: _state
    }) => stateFilter(_state))) {
      const {
        state
      } = alertState;
      statesByNodes[state.nodeId] = statesByNodes[state.nodeId] || [];
      statesByNodes[state.nodeId].push(alertState);
      alertsByNodes[state.nodeId] = alertsByNodes[state.nodeId] || {};
      alertsByNodes[state.nodeId][alertId] = alertsByNodes[alertState.state.nodeId][alertId] || {
        alert: sanitizedRule,
        states: [],
        count: 0
      };
      alertsByNodes[state.nodeId][alertId].count++;
      alertsByNodes[state.nodeId][alertId].states.push(alertState);
    }
  }
  for (const types of Object.values(alertsByNodes)) {
    for (const {
      states
    } of Object.values(types)) {
      states.sort(_sort_by_newest_alert.sortByNewestAlert);
    }
  }
  const nodeCount = Object.keys(statesByNodes).length;
  let secondaryPanelIndex = nodeCount;
  let tertiaryPanelIndex = nodeCount;
  const panels = [{
    id: 0,
    title: panelTitle,
    items: [...Object.keys(statesByNodes).map((nodeUuid, index) => {
      const states = statesByNodes[nodeUuid].filter(({
        state
      }) => stateFilter(state));
      const {
        nodeName,
        itemLabel
      } = states[0].state;
      return {
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, nodeName || itemLabel, " (", states.length, ")"),
        panel: index + 1
      };
    })]
  }, ...Object.keys(statesByNodes).reduce((accum, nodeUuid, nodeIndex) => {
    const alertsForNode = Object.values(alertsByNodes[nodeUuid]);
    const panelItems = [];
    let title = '';
    for (const {
      alert,
      states
    } of alertsForNode) {
      for (const alertState of states) {
        const {
          nodeName,
          itemLabel
        } = alertState.state;
        title = nodeName || itemLabel;
        panelItems.push({
          name: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            position: "top",
            content: (0, _formatting.getCalendar)(alertState.state.ui.triggeredMS, _legacy_shims.Legacy.shims.uiSettings.get('dateFormat:tz'))
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, (0, _formatting.getDateFromNow)(alertState.state.ui.triggeredMS, _legacy_shims.Legacy.shims.uiSettings.get('dateFormat:tz')))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, alert.name)),
          panel: ++secondaryPanelIndex
        });
      }
    }
    accum.push({
      id: nodeIndex + 1,
      title,
      items: panelItems
    });
    return accum;
  }, []), ...Object.keys(statesByNodes).reduce((accum, nodeUuid, nodeIndex) => {
    const alertsForNode = Object.values(alertsByNodes[nodeUuid]);
    for (const {
      alert,
      states
    } of alertsForNode) {
      for (const alertState of states) {
        accum.push({
          id: ++tertiaryPanelIndex,
          title: alert.name,
          width: 400,
          content: /*#__PURE__*/_react.default.createElement(_panel.AlertPanel, {
            alert: alert,
            alertState: alertState
          })
        });
      }
    }
    return accum;
  }, [])];
  return panels;
}