"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableAlertsModal = void 0;
exports.WatcherMigrationStep = WatcherMigrationStep;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _legacy_shims = require("../legacy_shims");
var _use_alerts_modal = require("../application/hooks/use_alerts_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnableAlertsModal = ({
  alerts
}) => {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const [promptForMigration, setPromptForMigration] = (0, _react.useState)(false);
  const alertsEnableModalProvider = (0, _use_alerts_modal.useAlertsModal)();
  (0, _react.useEffect)(() => {
    if (alertsEnableModalProvider.shouldShowAlertsModal(alerts)) {
      setIsModalVisible(true);
    }
  }, [alertsEnableModalProvider, alerts]);
  const closeModal = () => {
    setIsModalVisible(false);
    alertsEnableModalProvider.hideModalForSession();
  };
  const continueButtonClick = radioIdSelected => {
    if (radioIdSelected === 'create-alerts') {
      setPromptForMigration(true);
    } else {
      alertsEnableModalProvider.notAskAgain();
      closeModal();
    }
  };
  const createButtonClick = () => {
    alertsEnableModalProvider.enableAlerts();
    closeModal();
  };
  const remindLaterClick = () => {
    alertsEnableModalProvider.hideModalForSession();
    closeModal();
  };
  if (!isModalVisible) {
    return null;
  }
  return promptForMigration ? /*#__PURE__*/_react.default.createElement(WatcherMigrationStep, {
    closeModal: closeModal,
    createButtonClick: createButtonClick
  }) : /*#__PURE__*/_react.default.createElement(OptIntoRulesStep, {
    closeModal: closeModal,
    remindLaterClick: remindLaterClick,
    continueButtonClick: continueButtonClick
  });
};
exports.EnableAlertsModal = EnableAlertsModal;
function OptIntoRulesStep({
  closeModal,
  remindLaterClick,
  continueButtonClick
}) {
  const [radioIdSelected, setRadioIdSelected] = (0, _react.useState)('create-alerts');
  const onChange = optionId => {
    setRadioIdSelected(optionId);
  };
  const radios = [{
    id: 'create-alerts',
    label: _i18n.i18n.translate('xpack.monitoring.alerts.modal.yesOption', {
      defaultMessage: 'Yes (Recommended)'
    })
  }, {
    id: 'not-create-alerts',
    label: _i18n.i18n.translate('xpack.monitoring.alerts.modal.noOption', {
      defaultMessage: 'No'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.title",
    defaultMessage: "Create rules"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.description",
    defaultMessage: "Stack monitoring comes with many out-of-the box rules to notify you about issues around cluster health, resource utilization and errors. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _legacy_shims.Legacy.shims.docLinks.links.monitoring.alertsKibana,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.alerts.modal.description.link",
        defaultMessage: "Learn more"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.createDescription",
    defaultMessage: "Create these out-of-the box rules in this Kibana space?"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: radios,
    idSelected: radioIdSelected,
    onChange: id => onChange(id),
    name: "radio group"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: remindLaterClick,
    "data-test-subj": "alerts-modal-remind-later-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.remindLater",
    defaultMessage: "Remind me later"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => continueButtonClick(radioIdSelected),
    fill: true,
    "data-test-subj": "alerts-modal-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.confirm",
    defaultMessage: "Continue"
  }))));
}
function WatcherMigrationStep({
  closeModal,
  createButtonClick
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.migration.title",
    defaultMessage: "Migrate Elasticsearch Watches before continuing"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.migration.description.one",
    defaultMessage: "If you've used Internal Collection in the past, you'll have a few Elasticsearch Watches configured for your monitoring data."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.migration.description.two",
    defaultMessage: "To avoid duplication of work, it will be best to disable those before you create the Kibana rules."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.migration.description.three",
    defaultMessage: "To disable the Watches, you'll need to invoke the below API on each cluster where Internal Collection has been enabled in the past."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "POST /_monitoring/migrate/alerts")), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.migration.description.four",
    defaultMessage: "Once all monitoring Watches have been disabled, click Create to create the Kibana rules."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    "data-test-subj": "alerts-modal-cancel-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.migration.cancelButton.label",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: createButtonClick,
    fill: true,
    "data-test-subj": "alerts-modal-create-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.migration.confirmButton.label",
    defaultMessage: "Create"
  }))));
}