"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRAINED_MODEL_TYPE = exports.SUPPORTED_PYTORCH_TASKS = exports.RERANK_MODEL_ID = exports.MODEL_STATE = exports.LATEST_ELSER_VERSION = exports.LATEST_ELSER_MODEL_ID = exports.LATEST_E5_MODEL_ID = exports.LANG_IDENT_MODEL_ID = exports.ElserModels = exports.ELSER_MODEL_ID = exports.ELSER_LINUX_OPTIMIZED_MODEL_ID = exports.ELSER_ID_V1 = exports.ELASTIC_MODEL_TYPE = exports.ELASTIC_MODEL_TAG = exports.ELASTIC_MODEL_DEFINITIONS = exports.E5_MODEL_ID = exports.E5_LINUX_OPTIMIZED_MODEL_ID = exports.DEPLOYMENT_STATE = exports.BUILT_IN_MODEL_TYPE = exports.BUILT_IN_MODEL_TAG = void 0;
exports.isLocalModel = isLocalModel;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ELSER_MODEL_ID = exports.ELSER_MODEL_ID = '.elser_model_2';
const ELSER_LINUX_OPTIMIZED_MODEL_ID = exports.ELSER_LINUX_OPTIMIZED_MODEL_ID = '.elser_model_2_linux-x86_64';
const E5_MODEL_ID = exports.E5_MODEL_ID = '.multilingual-e5-small';
const E5_LINUX_OPTIMIZED_MODEL_ID = exports.E5_LINUX_OPTIMIZED_MODEL_ID = '.multilingual-e5-small_linux-x86_64';
const RERANK_MODEL_ID = exports.RERANK_MODEL_ID = '.rerank-v1';
const LANG_IDENT_MODEL_ID = exports.LANG_IDENT_MODEL_ID = 'lang_ident_model_1';
const ELSER_ID_V1 = exports.ELSER_ID_V1 = '.elser_model_1';
const LATEST_ELSER_VERSION = exports.LATEST_ELSER_VERSION = 2;
const LATEST_ELSER_MODEL_ID = exports.LATEST_ELSER_MODEL_ID = ELSER_LINUX_OPTIMIZED_MODEL_ID;
const LATEST_E5_MODEL_ID = exports.LATEST_E5_MODEL_ID = E5_LINUX_OPTIMIZED_MODEL_ID;
const ElserModels = exports.ElserModels = [ELSER_MODEL_ID, ELSER_LINUX_OPTIMIZED_MODEL_ID, ELSER_ID_V1];
const DEPLOYMENT_STATE = exports.DEPLOYMENT_STATE = {
  STARTED: 'started',
  STARTING: 'starting',
  STOPPING: 'stopping'
};
const TRAINED_MODEL_TYPE = exports.TRAINED_MODEL_TYPE = {
  PYTORCH: 'pytorch',
  TREE_ENSEMBLE: 'tree_ensemble',
  LANG_IDENT: 'lang_ident'
};
const SUPPORTED_PYTORCH_TASKS = exports.SUPPORTED_PYTORCH_TASKS = {
  NER: 'ner',
  QUESTION_ANSWERING: 'question_answering',
  ZERO_SHOT_CLASSIFICATION: 'zero_shot_classification',
  TEXT_CLASSIFICATION: 'text_classification',
  TEXT_EMBEDDING: 'text_embedding',
  FILL_MASK: 'fill_mask',
  // Not supported yet by the Trained Models UI
  TEXT_EXPANSION: 'text_expansion'
};
const BUILT_IN_MODEL_TYPE = exports.BUILT_IN_MODEL_TYPE = _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.builtInModelLabel', {
  defaultMessage: 'built-in'
});
const ELASTIC_MODEL_TYPE = exports.ELASTIC_MODEL_TYPE = 'elastic';
const BUILT_IN_MODEL_TAG = exports.BUILT_IN_MODEL_TAG = 'prepackaged';
const ELASTIC_MODEL_TAG = exports.ELASTIC_MODEL_TAG = 'elastic';
const ELASTIC_MODEL_DEFINITIONS = exports.ELASTIC_MODEL_DEFINITIONS = Object.freeze({
  [ELSER_ID_V1]: {
    modelName: 'elser',
    hidden: true,
    version: 1,
    config: {
      input: {
        field_names: ['text_field']
      }
    },
    description: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.elserDescription', {
      defaultMessage: 'Elastic Learned Sparse EncodeR v1 (Tech Preview)'
    }),
    type: ['elastic', 'pytorch', 'text_expansion']
  },
  [ELSER_MODEL_ID]: {
    modelName: 'elser',
    version: 2,
    default: true,
    config: {
      input: {
        field_names: ['text_field']
      }
    },
    description: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.elserV2Description', {
      defaultMessage: 'Elastic Learned Sparse EncodeR v2'
    }),
    type: ['elastic', 'pytorch', 'text_expansion']
  },
  [ELSER_LINUX_OPTIMIZED_MODEL_ID]: {
    modelName: 'elser',
    version: 2,
    os: 'Linux',
    arch: 'amd64',
    config: {
      input: {
        field_names: ['text_field']
      }
    },
    description: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.elserV2x86Description', {
      defaultMessage: 'Elastic Learned Sparse EncodeR v2, optimized for linux-x86_64'
    }),
    type: ['elastic', 'pytorch', 'text_expansion']
  },
  [E5_MODEL_ID]: {
    modelName: 'e5',
    version: 1,
    default: true,
    config: {
      input: {
        field_names: ['text_field']
      }
    },
    description: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.e5v1Description', {
      defaultMessage: 'E5 (EmbEddings from bidirEctional Encoder rEpresentations)'
    }),
    license: 'MIT',
    licenseUrl: 'https://huggingface.co/elastic/multilingual-e5-small',
    type: ['pytorch', 'text_embedding'],
    disclaimer: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.e5v1Disclaimer', {
      defaultMessage: 'This E5 model, as defined, hosted, integrated and used in conjunction with our other Elastic Software is covered by our standard warranty.'
    })
  },
  [E5_LINUX_OPTIMIZED_MODEL_ID]: {
    modelName: 'e5',
    version: 1,
    os: 'Linux',
    arch: 'amd64',
    config: {
      input: {
        field_names: ['text_field']
      }
    },
    description: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.e5v1x86Description', {
      defaultMessage: 'E5 (EmbEddings from bidirEctional Encoder rEpresentations), optimized for linux-x86_64'
    }),
    license: 'MIT',
    licenseUrl: 'https://huggingface.co/elastic/multilingual-e5-small_linux-x86_64',
    type: ['pytorch', 'text_embedding'],
    disclaimer: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.e5v1Disclaimer', {
      defaultMessage: 'This E5 model, as defined, hosted, integrated and used in conjunction with our other Elastic Software is covered by our standard warranty.'
    })
  },
  [RERANK_MODEL_ID]: {
    techPreview: true,
    default: true,
    hidden: true,
    modelName: 'rerank',
    version: 1,
    config: {
      input: {
        field_names: ['input', 'query']
      }
    },
    description: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.rerankDescription', {
      defaultMessage: 'Elastic Rerank v1'
    }),
    type: ['pytorch', 'text_similarity']
  }
});
const MODEL_STATE = exports.MODEL_STATE = {
  ...DEPLOYMENT_STATE,
  DOWNLOADING: 'downloading',
  DOWNLOADED: 'downloaded',
  NOT_DOWNLOADED: 'notDownloaded',
  DOWNLOADED_IN_DIFFERENT_SPACE: 'downloadedInDifferentSpace'
};
function isLocalModel(model) {
  return ['elser', 'elasticsearch'].includes(model.service);
}