"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inferenceModelRoutes = inferenceModelRoutes;
var _error_wrapper = require("../client/error_wrapper");
var _app = require("../../common/constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function inferenceModelRoutes({
  router,
  routeGuard,
  getEnabledFeatures
}, cloud) {
  router.versioned.get({
    path: `${_app.ML_INTERNAL_BASE_PATH}/_inference/all`,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: ['ml:canGetTrainedModels']
      }
    },
    summary: 'Get all inference endpoints',
    description: 'Get all inference endpoints'
  }).addVersion({
    version: '1',
    validate: false
  }, routeGuard.fullLicenseAPIGuard(async ({
    client,
    response
  }) => {
    try {
      const body = await client.asCurrentUser.inference.get({
        inference_id: '_all'
      });
      return response.ok({
        body
      });
    } catch (e) {
      return response.customError((0, _error_wrapper.wrapError)(e));
    }
  }));
}