"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _events = require("./events");
var _telemetry_client = require("./telemetry_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryService {
  constructor() {
    (0, _defineProperty2.default)(this, "analytics", void 0);
  }
  setup({
    analytics
  }) {
    this.analytics = analytics;
    analytics.registerEventType(_events.trainedModelsEbtEvents.trainedModelsDeploymentCreatedEventType);
    analytics.registerEventType(_events.trainedModelsEbtEvents.trainedModelsModelDownloadEventType);
    analytics.registerEventType(_events.trainedModelsEbtEvents.trainedModelsDeploymentUpdatedEventType);
    analytics.registerEventType(_events.trainedModelsEbtEvents.trainedModelsModelTestedEventType);
  }
  start() {
    if (!this.analytics) {
      throw new Error('The TelemetryService.setup() method has not been invoked, be sure to call it during the plugin setup.');
    }
    return new _telemetry_client.TelemetryClient(this.analytics);
  }
}
exports.TelemetryService = TelemetryService;