"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _i18nReact = require("@kbn/i18n-react");
var _collapsible_panel = require("../../../components/collapsible_panel/collapsible_panel");
var _storage = require("../../../../../common/types/storage");
var _table = require("./table");
var _analytics_service = require("../../../data_frame_analytics/pages/analytics_management/services/analytics_service");
var _kibana = require("../../../contexts/kibana");
var _locator = require("../../../../../common/constants/locator");
var _use_refresh = require("../../../routing/use_refresh");
var _empty_prompt = require("../../../data_frame_analytics/pages/analytics_management/components/empty_prompt");
var _overview_page = require("../../overview_page");
var _collapsible_panel2 = require("../../../components/collapsible_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsPanel = ({
  setLazyJobCount
}) => {
  const refresh = (0, _use_refresh.useRefresh)();
  const [analytics, setAnalytics] = (0, _react.useState)([]);
  const [analyticsStats, setAnalyticsStats] = (0, _react.useState)(undefined);
  const [errorMessage, setErrorMessage] = (0, _react.useState)();
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const manageJobsLink = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE
  });
  const [panelsState, setPanelsState] = (0, _mlLocalStorage.useStorage)(_storage.ML_OVERVIEW_PANELS, _overview_page.overviewPanelDefaultState);
  const setAnalyticsStatsCustom = (0, _react.useCallback)(stats => {
    if (!stats) return;
    const result = Object.entries(stats).filter(([k, v]) => v.show).map(([k, v]) => v);
    setAnalyticsStats(result);
  }, []);
  const getAnalytics = (0, _analytics_service.useGetAnalytics)(setAnalytics, setAnalyticsStatsCustom, setErrorMessage, setIsInitialized, setLazyJobCount, false);
  (0, _react.useEffect)(() => {
    getAnalytics(true);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refresh]);
  const errorDisplay = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.overview.analyticsList.errorPromptTitle', {
      defaultMessage: 'An error occurred getting the data frame analytics list.'
    }),
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("pre", null, errorMessage && errorMessage.message !== undefined ? errorMessage.message : JSON.stringify(errorMessage)));
  const noDFAJobs = errorMessage === undefined && isInitialized === true && analytics.length === 0;
  return /*#__PURE__*/_react.default.createElement(_collapsible_panel2.CollapsiblePanel, {
    isOpen: panelsState.dfaJobs,
    onToggle: update => {
      setPanelsState({
        ...panelsState,
        dfaJobs: update
      });
    },
    header: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.analyticsList.PanelTitle",
      defaultMessage: "Data Frame Analytics Jobs"
    }),
    headerItems: [...(analyticsStats ? [/*#__PURE__*/_react.default.createElement(_collapsible_panel.OverviewStatsBar, {
      inputStats: analyticsStats,
      dataTestSub: 'mlOverviewAnalyticsStatsBar'
    })] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: manageJobsLink
    }, _i18n.i18n.translate('xpack.ml.overview.analyticsList.manageJobsButtonText', {
      defaultMessage: 'Manage jobs'
    }))],
    ariaLabel: _i18n.i18n.translate('xpack.ml.overview.analyticsListPanel.ariaLabel', {
      defaultMessage: 'data frame analytics panel'
    })
  }, noDFAJobs ? /*#__PURE__*/_react.default.createElement(_empty_prompt.AnalyticsEmptyPrompt, null) : null, typeof errorMessage !== 'undefined' ? errorDisplay : null, isInitialized === false && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    css: {
      display: 'inline-block'
    },
    size: "xl"
  }), isInitialized === true && analytics.length > 0 ? /*#__PURE__*/_react.default.createElement(_table.AnalyticsTable, {
    items: analytics
  }) : null);
};
exports.AnalyticsPanel = AnalyticsPanel;