"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTestable = isTestable;
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _trained_models = require("../../../../common/types/trained_models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PYTORCH_TYPES = Object.values(_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS);
function isTestable(modelItem, checkForState = false) {
  var _modelItem$inference_, _modelItem$stats, _modelItem$stats$depl;
  if ((0, _trained_models.isNLPModelItem)(modelItem) && PYTORCH_TYPES.includes(Object.keys((_modelItem$inference_ = modelItem.inference_config) !== null && _modelItem$inference_ !== void 0 ? _modelItem$inference_ : {})[0]) && (checkForState === false || (_modelItem$stats = modelItem.stats) !== null && _modelItem$stats !== void 0 && (_modelItem$stats$depl = _modelItem$stats.deployment_stats) !== null && _modelItem$stats$depl !== void 0 && _modelItem$stats$depl.some(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTED))) {
    return true;
  }
  if ((0, _trained_models.isExistingModel)(modelItem) && modelItem.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.LANG_IDENT) {
    return true;
  }
  return (0, _trained_models.isDFAModelItem)(modelItem);
}