"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PartitionFieldDescription = exports.OverFieldDescription = exports.FieldDescription = exports.ExcludeFrequentDescription = exports.DescriptionDescription = exports.ByFieldDescription = exports.AggDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _function_help = require("./function_help");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AggDescription = exports.AggDescription = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.aggSelect.title', {
    defaultMessage: 'Function'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_function_help.FunctionHelpPopover, null))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.aggSelect.description",
      defaultMessage: "Analysis functions to be performed. For example, sum, count."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
});
const FieldDescription = exports.FieldDescription = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.fieldSelect.title', {
    defaultMessage: 'Field'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, title),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.fieldSelect.description",
      defaultMessage: "Required for functions: sum, mean, median, max, min, info_content, distinct_count, lat_long."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
});
const ByFieldDescription = exports.ByFieldDescription = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.byFieldSelect.title', {
    defaultMessage: 'By field'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, title),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.byFieldSelect.description",
      defaultMessage: "Required for individual analysis where anomalies are detected compared to an entity's own past behavior."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
});
const OverFieldDescription = exports.OverFieldDescription = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.overFieldSelect.title', {
    defaultMessage: 'Over field'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, title),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.overFieldSelect.description",
      defaultMessage: "Required for population analysis where anomalies are detected compared to the behavior of the population."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
});
const PartitionFieldDescription = exports.PartitionFieldDescription = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.partitionFieldSelect.title', {
    defaultMessage: 'Partition field'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, title),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.partitionFieldSelect.description",
      defaultMessage: "Allows segmentation of modeling into logical groups."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
});
const ExcludeFrequentDescription = exports.ExcludeFrequentDescription = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.excludeFrequent.title', {
    defaultMessage: 'Exclude frequent'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, title),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.excludeFrequent.description",
      defaultMessage: "If set, it will automatically identify and exclude frequently occurring entities which may otherwise have dominated results."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
});
const DescriptionDescription = exports.DescriptionDescription = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.description.title', {
    defaultMessage: 'Description'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, title),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.description.description",
      defaultMessage: "Override the default detector description with a meaningful description of what the detector is analyzing."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
});