"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartLoader = void 0;
exports.getAggFieldPairNames = getAggFieldPairNames;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _lodash = require("lodash");
var _results_service = require("../../../../services/results_service");
var _searches = require("./searches");
var _general = require("../job_creator/util/general");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const eq = (newArgs, lastArgs) => (0, _lodash.isEqual)(newArgs, lastArgs);
class ChartLoader {
  constructor(mlApi, indexPattern, query) {
    (0, _defineProperty2.default)(this, "_dataView", void 0);
    (0, _defineProperty2.default)(this, "_mlApi", void 0);
    (0, _defineProperty2.default)(this, "_timeFieldName", '');
    (0, _defineProperty2.default)(this, "_query", {});
    (0, _defineProperty2.default)(this, "_newJobLineChart", void 0);
    (0, _defineProperty2.default)(this, "_newJobPopulationsChart", void 0);
    (0, _defineProperty2.default)(this, "_getEventRateData", void 0);
    (0, _defineProperty2.default)(this, "_getCategoryFields", void 0);
    this._mlApi = mlApi;
    this._dataView = indexPattern;
    this._query = query;
    this._newJobLineChart = (0, _memoizeOne.default)(mlApi.jobs.newJobLineChart, eq);
    this._newJobPopulationsChart = (0, _memoizeOne.default)(mlApi.jobs.newJobPopulationsChart, eq);
    this._getEventRateData = (0, _memoizeOne.default)((0, _results_service.mlResultsServiceProvider)(mlApi).getEventRateData, eq);
    this._getCategoryFields = (0, _memoizeOne.default)(_searches.getCategoryFields, eq);
    if (typeof indexPattern.timeFieldName === 'string') {
      this._timeFieldName = indexPattern.timeFieldName;
    }
  }
  async loadLineCharts(start, end, aggFieldPairs, splitField, splitFieldValue, intervalMs, runtimeMappings, indicesOptions) {
    if (this._timeFieldName !== '') {
      if ((0, _general.aggFieldPairsCanBeCharted)(aggFieldPairs) === false) {
        // no elasticsearch aggregation, this must contain ML only functions
        return {};
      }
      const splitFieldName = splitField !== null ? splitField.name : null;
      const aggFieldPairNames = aggFieldPairs.map(getAggFieldPairNames);
      const resp = await this._newJobLineChart(this._dataView.getIndexPattern(), this._timeFieldName, start, end, intervalMs, this._query, aggFieldPairNames, splitFieldName, splitFieldValue, runtimeMappings !== null && runtimeMappings !== void 0 ? runtimeMappings : undefined, indicesOptions);
      return resp.results;
    }
    return {};
  }
  async loadPopulationCharts(start, end, aggFieldPairs, splitField, intervalMs, runtimeMappings, indicesOptions) {
    if (this._timeFieldName !== '') {
      if ((0, _general.aggFieldPairsCanBeCharted)(aggFieldPairs) === false) {
        // no elasticsearch aggregation, this must contain ML only functions
        return {};
      }
      const splitFieldName = splitField !== null ? splitField.name : '';
      const aggFieldPairNames = aggFieldPairs.map(getAggFieldPairNames);
      const resp = await this._newJobPopulationsChart(this._dataView.getIndexPattern(), this._timeFieldName, start, end, intervalMs, this._query, aggFieldPairNames, splitFieldName, runtimeMappings !== null && runtimeMappings !== void 0 ? runtimeMappings : undefined, indicesOptions);
      return resp.results;
    }
    return {};
  }
  async loadEventRateChart(start, end, intervalMs, runtimeMappings, indicesOptions) {
    if (this._timeFieldName !== '') {
      const resp = await this._getEventRateData(this._dataView.getIndexPattern(), this._query, this._timeFieldName, start, end, intervalMs * 3, runtimeMappings, indicesOptions);
      if (resp.error !== undefined) {
        throw resp.error;
      }
      return Object.entries(resp.results).map(([time, value]) => ({
        time: +time,
        value: value
      }));
    }
    return [];
  }
  async loadFieldExampleValues(field, runtimeMappings, indicesOptions) {
    const {
      results
    } = await this._getCategoryFields(this._mlApi, this._dataView.getIndexPattern(), field.name, 10, this._query, runtimeMappings !== null && runtimeMappings !== void 0 ? runtimeMappings : undefined, indicesOptions);
    return results;
  }
}
exports.ChartLoader = ChartLoader;
function getAggFieldPairNames(af) {
  const by = af.by !== undefined && af.by.field !== null && af.by.value !== null ? {
    field: af.by.field.id,
    value: af.by.value
  } : {
    field: null,
    value: null
  };
  return {
    agg: af.agg.dslName || '',
    field: af.field.id,
    by
  };
}