"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedJobsWarningCallout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagedJobsWarningCallout = ({
  jobsCount,
  action,
  message
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, message !== null && message !== void 0 ? message : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.managedJobsWarningCallout",
    defaultMessage: "{jobsCount, plural, one {This job} other {At least one of these jobs}} is preconfigured by Elastic; {action} {jobsCount, plural, one {it} other {them}} might impact other parts of the product.",
    values: {
      jobsCount,
      action
    }
  })));
};
exports.ManagedJobsWarningCallout = ManagedJobsWarningCallout;