"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.viewActionButtonText = exports.ViewButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _get_view_link_status = require("./get_view_link_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const viewActionButtonText = exports.viewActionButtonText = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.viewActionName', {
  defaultMessage: 'View'
});
const ViewButton = ({
  item
}) => {
  const {
    disabled,
    tooltipContent
  } = (0, _get_view_link_status.getViewLinkStatus)(item);
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: tooltipContent
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, viewActionButtonText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, viewActionButtonText);
};
exports.ViewButton = ViewButton;