"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RocCurveHelpPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _help_popover = require("../../../../../components/help_popover/help_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RocCurveHelpPopover = () => {
  return /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopover, {
    anchorPosition: "upCenter",
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.rocCurvePopoverTitle', {
      defaultMessage: 'Receiver operating characteristic (ROC) curve'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.rocCurveBasicExplanation",
    defaultMessage: "The ROC curve is a plot that represents the performance of the classification process at different predicted probability thresholds."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.rocCurveCompute",
    defaultMessage: "It compares the true positive rate (y-axis) for a specific class against the false positive rate (x-axis) at the different threshold levels to create the curve."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.rocCurveAuc",
    defaultMessage: "From this plot, the area under the curve (AUC) value can be computed, which is a number between 0 and 1. The closer to 1, the better the algorithm performance."
  })));
};
exports.RocCurveHelpPopover = RocCurveHelpPopover;