"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidationStepDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _page = require("../../page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ValidationStepDetails = ({
  setCurrentStep,
  state,
  validationSummary
}) => {
  const {
    isJobCreated
  } = state;
  const detailsFirstCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.validatioinDetails.successfulChecks', {
      defaultMessage: 'Successful checks'
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, validationSummary.success)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check"
    }))))
  }];
  const detailsSecondCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.validatioinDetails.warnings', {
      defaultMessage: 'Warnings'
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, validationSummary.warning)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning"
    }))))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      width: '70%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsFirstCol
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    style: {
      wordBreak: 'break-word'
    },
    compressed: true,
    listItems: detailsSecondCol
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !isJobCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.VALIDATION);
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.validationDetails.viewButtonText', {
    defaultMessage: 'View'
  })));
};
exports.ValidationStepDetails = ValidationStepDetails;