"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineNameAndDescription = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineNameAndDescription = ({
  pipelineName,
  pipelineNameError,
  pipelineDescription,
  handlePipelineConfigUpdate
}) => {
  const handleConfigChange = (value, type) => {
    handlePipelineConfigUpdate({
      [type]: value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.nameLabel', {
      defaultMessage: 'Name'
    }),
    helpText: !pipelineNameError && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.name.helpText', {
      defaultMessage: 'Pipeline names are unique within a deployment and can only contain letters, numbers, underscores, and hyphens.'
    })),
    error: pipelineNameError,
    isInvalid: pipelineNameError !== undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "mlTrainedModelsInferencePipelineNameInput",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.namePlaceholder', {
      defaultMessage: 'Enter a unique name for this pipeline'
    }),
    value: pipelineName,
    onChange: e => handleConfigChange(e.target.value, 'pipelineName')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.description.helpText', {
      defaultMessage: 'A description of the pipeline.'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    compressed: true,
    fullWidth: true,
    "data-test-subj": "mlTrainedModelsInferencePipelineDescriptionInput",
    placeholder: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.descriptionPlaceholder', {
      defaultMessage: 'Add a pipeline description.'
    }),
    value: pipelineDescription,
    onChange: e => handleConfigChange(e.target.value, 'pipelineDescription')
  })));
};
exports.PipelineNameAndDescription = PipelineNameAndDescription;