"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlPageHeaderRenderer = exports.MlPageHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _eui = require("@elastic/eui");
var _ml_page = require("../ml_page/ml_page");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component for setting the page header content.
 */
const MlPageHeader = ({
  children
}) => {
  const {
    headerPortal,
    setIsHeaderMounted
  } = (0, _react.useContext)(_ml_page.MlPageControlsContext);
  (0, _react.useEffect)(() => {
    setIsHeaderMounted(true);
    return () => {
      setIsHeaderMounted(false);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: headerPortal
  }, children);
};

/**
 * Renders content of the {@link MlPageHeader}
 */
exports.MlPageHeader = MlPageHeader;
const MlPageHeaderRenderer = () => {
  const {
    headerPortal,
    isHeaderMounted
  } = (0, _react.useContext)(_ml_page.MlPageControlsContext);
  return isHeaderMounted ? /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
    node: headerPortal
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1
  });
};
exports.MlPageHeaderRenderer = MlPageHeaderRenderer;