"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInfluencersListStyles = void 0;
var _react = require("@emotion/react");
var _mlKibanaTheme = require("@kbn/ml-kibana-theme");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInfluencersListStyles = () => {
  const {
    services: {
      theme
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _mlKibanaTheme.useCurrentEuiThemeVars)(theme);
  return {
    influencersList: (0, _react.css)({
      lineHeight: 1.45
    }),
    fieldLabel: (0, _react.css)({
      fontSize: euiTheme.euiFontSizeXS,
      textAlign: 'left',
      maxHeight: euiTheme.euiFontSizeM,
      maxWidth: 'calc(100% - 102px)'
    }),
    progress: (0, _react.css)({
      display: 'inline-block',
      width: 'calc(100% - 34px)',
      height: '22px',
      minWidth: '70px',
      marginBottom: 0,
      color: euiTheme.euiColorDarkShade,
      backgroundColor: 'transparent'
    }),
    progressBarHolder: (0, _react.css)({
      width: `calc(100% - 28px)`
    }),
    progressBar: (severity, barScore) => (0, _react.css)({
      height: `calc(${euiTheme.euiSizeXS} / 2)`,
      float: 'left',
      marginTop: euiTheme.euiSizeM,
      textAlign: 'right',
      lineHeight: '18px',
      display: 'inline-block',
      transition: 'none',
      width: `${barScore}%`,
      backgroundColor: severity === 'critical' ? _mlAnomalyUtils.ML_SEVERITY_COLORS.CRITICAL : severity === 'major' ? _mlAnomalyUtils.ML_SEVERITY_COLORS.MAJOR : severity === 'minor' ? _mlAnomalyUtils.ML_SEVERITY_COLORS.MINOR : _mlAnomalyUtils.ML_SEVERITY_COLORS.WARNING
    }),
    scoreLabel: severity => (0, _react.css)({
      textAlign: 'center',
      lineHeight: '14px',
      whiteSpace: 'nowrap',
      fontSize: euiTheme.euiFontSizeXS,
      marginLeft: euiTheme.euiSizeXS,
      display: 'inline',
      borderColor: severity === 'critical' ? _mlAnomalyUtils.ML_SEVERITY_COLORS.CRITICAL : severity === 'major' ? _mlAnomalyUtils.ML_SEVERITY_COLORS.MAJOR : severity === 'minor' ? _mlAnomalyUtils.ML_SEVERITY_COLORS.MINOR : _mlAnomalyUtils.ML_SEVERITY_COLORS.WARNING
    }),
    totalScoreLabel: (0, _react.css)({
      width: euiTheme.euiSizeXL,
      verticalAlign: 'top',
      textAlign: 'center',
      color: euiTheme.euiColorDarkShade,
      fontSize: '11px',
      lineHeight: '14px',
      borderRadius: euiTheme.euiBorderRadius,
      padding: `calc(${euiTheme.euiSizeXS} / 2)`,
      display: 'inline-block',
      border: euiTheme.euiBorderThin
    })
  };
};
exports.useInfluencersListStyles = useInfluencersListStyles;